/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.compress;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.statistics.IOStatisticsSupport;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.compress.CodecPool;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.compress.Compressor;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class CompressionOutputStream
extends OutputStream
implements IOStatisticsSource {
    protected final OutputStream out;
    private Compressor trackedCompressor;

    protected CompressionOutputStream(OutputStream out) {
        this.out = out;
    }

    void setTrackedCompressor(Compressor compressor) {
        this.trackedCompressor = compressor;
    }

    @Override
    public void close() throws IOException {
        try {
            this.finish();
        }
        finally {
            try {
                this.out.close();
            }
            finally {
                if (this.trackedCompressor != null) {
                    CodecPool.returnCompressor(this.trackedCompressor);
                    this.trackedCompressor = null;
                }
            }
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public abstract void finish() throws IOException;

    public abstract void resetState() throws IOException;

    @Override
    public IOStatistics getIOStatistics() {
        return IOStatisticsSupport.retrieveIOStatistics(this.out);
    }
}

