/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.azurefs;

import java.io.IOException;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.fs.azure.common.hadoop.HadoopFsRecoverable;
import org.apache.flink.fs.azure.common.hadoop.HadoopRecoverableWriter;
import org.apache.flink.fs.azurefs.AzureBlobFsRecoverableDataOutputStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path;

public class AzureBlobRecoverableWriter
extends HadoopRecoverableWriter {
    public AzureBlobRecoverableWriter(FileSystem fs) {
        super(fs);
    }

    @Override
    protected void checkSupportedFSSchemes(FileSystem fs) {
        if (!"abfs".equalsIgnoreCase(fs.getScheme()) && !"abfss".equalsIgnoreCase(fs.getScheme())) {
            throw new UnsupportedOperationException("Recoverable writers on AzureBlob are only supported for ABFS");
        }
    }

    @Override
    protected RecoverableFsDataOutputStream getRecoverableFsDataOutputStream(Path targetFile, Path tempFile) throws IOException {
        return new AzureBlobFsRecoverableDataOutputStream(this.fs, targetFile, tempFile);
    }

    @Override
    public RecoverableFsDataOutputStream recover(RecoverableWriter.ResumeRecoverable recoverable) throws IOException {
        return new AzureBlobFsRecoverableDataOutputStream(this.fs, (HadoopFsRecoverable)recoverable);
    }

    @Override
    public RecoverableFsDataOutputStream.Committer recoverForCommit(RecoverableWriter.CommitRecoverable recoverable) throws IOException {
        return new AzureBlobFsRecoverableDataOutputStream.ABFSCommitter(this.fs, (HadoopFsRecoverable)recoverable);
    }
}

