/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.file;

import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.AccessCondition;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.DoesServiceRequest;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.OperationContext;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.RequestOptions;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.ResultContinuation;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.ResultContinuationType;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.ResultSegment;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.StorageCredentials;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.StorageCredentialsSharedAccessSignature;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.StorageException;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.StorageUri;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.BaseResponse;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.ExecutionEngine;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.LazySegmentedIterable;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.ListResponse;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.ListingContext;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.PathUtility;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.RequestLocationMode;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.SegmentedStorageRequest;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.SharedAccessSignatureHelper;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.StorageRequest;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.Utility;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.file.CloudFile;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.file.CloudFileClient;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.file.CloudFileShare;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.file.FileDirectoryAttributes;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.file.FileDirectoryProperties;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.file.FileListHandler;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.file.FileRequest;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.file.FileRequestOptions;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.file.FileResponse;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.file.ListFileItem;

public final class CloudFileDirectory
implements ListFileItem {
    private CloudFileShare share;
    private CloudFileDirectory parent;
    private CloudFileClient fileServiceClient;
    private StorageUri storageUri;
    private String name;
    private HashMap<String, String> metadata = new HashMap();
    private FileDirectoryProperties properties = new FileDirectoryProperties();

    public CloudFileDirectory(URI directoryAbsoluteUri) throws StorageException, URISyntaxException {
        this(new StorageUri(directoryAbsoluteUri));
    }

    public CloudFileDirectory(StorageUri directoryAbsoluteUri) throws StorageException, URISyntaxException {
        this(directoryAbsoluteUri, (StorageCredentials)null);
    }

    public CloudFileDirectory(URI directoryAbsoluteUri, StorageCredentials credentials) throws StorageException, URISyntaxException {
        this(new StorageUri(directoryAbsoluteUri), credentials);
    }

    public CloudFileDirectory(StorageUri directoryAbsoluteUri, StorageCredentials credentials) throws StorageException, URISyntaxException {
        this.parseQueryAndVerify(directoryAbsoluteUri, credentials);
    }

    protected CloudFileDirectory(StorageUri uri, String directoryName, CloudFileShare share) {
        Utility.assertNotNull("uri", uri);
        Utility.assertNotNull("directoryName", directoryName);
        Utility.assertNotNull("share", share);
        this.name = directoryName;
        this.fileServiceClient = share.getServiceClient();
        this.share = share;
        this.storageUri = uri;
    }

    @DoesServiceRequest
    public void create() throws StorageException, URISyntaxException {
        this.create(null, null);
    }

    @DoesServiceRequest
    public void create(FileRequestOptions options, OperationContext opContext) throws StorageException, URISyntaxException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        this.getShare().assertNoSnapshot();
        opContext.initialize();
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.createDirectoryImpl(options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, CloudFileDirectory, Void> createDirectoryImpl(final FileRequestOptions options) {
        StorageRequest<CloudFileClient, CloudFileDirectory, Void> putRequest = new StorageRequest<CloudFileClient, CloudFileDirectory, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFileDirectory directory, OperationContext context) throws Exception {
                HttpURLConnection request = FileRequest.createDirectory(directory.getTransformedAddress().getUri(this.getCurrentLocation()), options, context);
                return request;
            }

            @Override
            public void setHeaders(HttpURLConnection connection, CloudFileDirectory directory, OperationContext context) {
                FileRequest.addMetadata(connection, directory.getMetadata(), context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, context);
            }

            @Override
            public Void preProcessResponse(CloudFileDirectory directory, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 201) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                FileDirectoryAttributes attributes = FileResponse.getFileDirectoryAttributes(this.getConnection(), client.isUsePathStyleUris());
                directory.setProperties(attributes.getProperties());
                this.getResult().setRequestServiceEncrypted(BaseResponse.isServerRequestEncrypted(this.getConnection()));
                return null;
            }
        };
        return putRequest;
    }

    @DoesServiceRequest
    public boolean createIfNotExists() throws StorageException, URISyntaxException {
        return this.createIfNotExists(null, null);
    }

    @DoesServiceRequest
    public boolean createIfNotExists(FileRequestOptions options, OperationContext opContext) throws StorageException, URISyntaxException {
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        this.getShare().assertNoSnapshot();
        boolean exists = this.exists(true, null, options, opContext);
        if (exists) {
            return false;
        }
        try {
            this.create(options, opContext);
            return true;
        }
        catch (StorageException e) {
            if (e.getHttpStatusCode() == 409 && "ResourceAlreadyExists".equals(e.getErrorCode())) {
                return false;
            }
            throw e;
        }
    }

    @DoesServiceRequest
    public void delete() throws StorageException, URISyntaxException {
        this.delete(null, null, null);
    }

    @DoesServiceRequest
    public void delete(AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException, URISyntaxException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        this.getShare().assertNoSnapshot();
        opContext.initialize();
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.deleteDirectoryImpl(accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, CloudFileDirectory, Void> deleteDirectoryImpl(final AccessCondition accessCondition, final FileRequestOptions options) {
        StorageRequest<CloudFileClient, CloudFileDirectory, Void> putRequest = new StorageRequest<CloudFileClient, CloudFileDirectory, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFileDirectory directory, OperationContext context) throws Exception {
                return FileRequest.deleteDirectory(directory.getTransformedAddress().getUri(this.getCurrentLocation()), options, context, accessCondition);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, context);
            }

            @Override
            public Void preProcessResponse(CloudFileDirectory directory, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 202) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }
        };
        return putRequest;
    }

    @DoesServiceRequest
    public boolean deleteIfExists() throws StorageException, URISyntaxException {
        return this.deleteIfExists(null, null, null);
    }

    @DoesServiceRequest
    public boolean deleteIfExists(AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException, URISyntaxException {
        boolean exists = this.exists(true, accessCondition, options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient), opContext);
        if (exists) {
            try {
                this.delete(accessCondition, options, opContext);
                return true;
            }
            catch (StorageException e) {
                if (e.getHttpStatusCode() == 404 && "ResourceNotFound".equals(e.getErrorCode())) {
                    return false;
                }
                throw e;
            }
        }
        return false;
    }

    @DoesServiceRequest
    public boolean exists() throws StorageException {
        return this.exists(null, null, null);
    }

    @DoesServiceRequest
    public boolean exists(AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException {
        return this.exists(false, accessCondition, options, opContext);
    }

    @DoesServiceRequest
    private boolean exists(boolean primaryOnly, AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        return ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.existsImpl(primaryOnly, accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, CloudFileDirectory, Boolean> existsImpl(final boolean primaryOnly, final AccessCondition accessCondition, final FileRequestOptions options) {
        StorageRequest<CloudFileClient, CloudFileDirectory, Boolean> getRequest = new StorageRequest<CloudFileClient, CloudFileDirectory, Boolean>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(primaryOnly ? RequestLocationMode.PRIMARY_ONLY : RequestLocationMode.PRIMARY_OR_SECONDARY);
            }

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFileDirectory directory, OperationContext context) throws Exception {
                return FileRequest.getDirectoryProperties(directory.getTransformedAddress().getUri(this.getCurrentLocation()), options, context, accessCondition, directory.getShare().snapshotID);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, context);
            }

            @Override
            public Boolean preProcessResponse(CloudFileDirectory directory, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() == 200) {
                    directory.updatePropertiesFromResponse(this.getConnection());
                    FileDirectoryAttributes attributes = FileResponse.getFileDirectoryAttributes(this.getConnection(), client.isUsePathStyleUris());
                    directory.setMetadata(attributes.getMetadata());
                    directory.setProperties(attributes.getProperties());
                    return true;
                }
                if (this.getResult().getStatusCode() == 404) {
                    return false;
                }
                this.setNonExceptionedRetryableFailure(true);
                return false;
            }
        };
        return getRequest;
    }

    private void updatePropertiesFromResponse(HttpURLConnection request) {
        this.getProperties().setEtag(request.getHeaderField("ETag"));
        if (0L != request.getLastModified()) {
            Calendar lastModifiedCalendar = Calendar.getInstance(Utility.LOCALE_US);
            lastModifiedCalendar.setTimeZone(Utility.UTC_ZONE);
            lastModifiedCalendar.setTime(new Date(request.getLastModified()));
            this.getProperties().setLastModified(lastModifiedCalendar.getTime());
        }
    }

    @DoesServiceRequest
    public void uploadMetadata() throws StorageException, URISyntaxException {
        this.uploadMetadata(null, null, null);
    }

    @DoesServiceRequest
    public void uploadMetadata(AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException, URISyntaxException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        this.getShare().assertNoSnapshot();
        opContext.initialize();
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.uploadMetadataImpl(accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, CloudFileDirectory, Void> uploadMetadataImpl(final AccessCondition accessCondition, final FileRequestOptions options) {
        StorageRequest<CloudFileClient, CloudFileDirectory, Void> putRequest = new StorageRequest<CloudFileClient, CloudFileDirectory, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFileDirectory directory, OperationContext context) throws Exception {
                return FileRequest.setDirectoryMetadata(directory.getTransformedAddress().getUri(this.getCurrentLocation()), options, context, accessCondition);
            }

            @Override
            public void setHeaders(HttpURLConnection connection, CloudFileDirectory directory, OperationContext context) {
                FileRequest.addMetadata(connection, directory.getMetadata(), context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, context);
            }

            @Override
            public Void preProcessResponse(CloudFileDirectory directory, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                directory.updatePropertiesFromResponse(this.getConnection());
                this.getResult().setRequestServiceEncrypted(BaseResponse.isServerRequestEncrypted(this.getConnection()));
                return null;
            }
        };
        return putRequest;
    }

    @DoesServiceRequest
    public void downloadAttributes() throws StorageException {
        this.downloadAttributes(null, null, null);
    }

    @DoesServiceRequest
    public void downloadAttributes(AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.downloadAttributesImpl(accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, CloudFileDirectory, Void> downloadAttributesImpl(final AccessCondition accessCondition, final FileRequestOptions options) {
        StorageRequest<CloudFileClient, CloudFileDirectory, Void> getRequest = new StorageRequest<CloudFileClient, CloudFileDirectory, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(RequestLocationMode.PRIMARY_OR_SECONDARY);
            }

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFileDirectory directory, OperationContext context) throws Exception {
                return FileRequest.getDirectoryProperties(directory.getTransformedAddress().getUri(this.getCurrentLocation()), options, context, accessCondition, directory.getShare().snapshotID);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, context);
            }

            @Override
            public Void preProcessResponse(CloudFileDirectory directory, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                FileDirectoryAttributes attributes = FileResponse.getFileDirectoryAttributes(this.getConnection(), client.isUsePathStyleUris());
                directory.setMetadata(attributes.getMetadata());
                directory.setProperties(attributes.getProperties());
                return null;
            }
        };
        return getRequest;
    }

    @DoesServiceRequest
    public Iterable<ListFileItem> listFilesAndDirectories() {
        return this.listFilesAndDirectories(null, null, null);
    }

    @DoesServiceRequest
    public Iterable<ListFileItem> listFilesAndDirectories(FileRequestOptions options, OperationContext opContext) {
        return this.listFilesAndDirectories(null, options, opContext);
    }

    @DoesServiceRequest
    public Iterable<ListFileItem> listFilesAndDirectories(String prefix, FileRequestOptions options, OperationContext opContext) {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        SegmentedStorageRequest segmentedRequest = new SegmentedStorageRequest();
        return new LazySegmentedIterable<CloudFileClient, CloudFileDirectory, ListFileItem>(this.listFilesAndDirectoriesSegmentedImpl(prefix, null, options, segmentedRequest), this.fileServiceClient, this, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public ResultSegment<ListFileItem> listFilesAndDirectoriesSegmented() throws StorageException {
        return this.listFilesAndDirectoriesSegmented(null, null, null, null, null);
    }

    @DoesServiceRequest
    public ResultSegment<ListFileItem> listFilesAndDirectoriesSegmented(Integer maxResults, ResultContinuation continuationToken, FileRequestOptions options, OperationContext opContext) throws StorageException {
        return this.listFilesAndDirectoriesSegmented(null, maxResults, continuationToken, options, opContext);
    }

    @DoesServiceRequest
    public ResultSegment<ListFileItem> listFilesAndDirectoriesSegmented(String prefix, Integer maxResults, ResultContinuation continuationToken, FileRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        Utility.assertContinuationType(continuationToken, ResultContinuationType.FILE);
        SegmentedStorageRequest segmentedRequest = new SegmentedStorageRequest();
        segmentedRequest.setToken(continuationToken);
        return ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.listFilesAndDirectoriesSegmentedImpl(prefix, maxResults, options, segmentedRequest), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, CloudFileDirectory, ResultSegment<ListFileItem>> listFilesAndDirectoriesSegmentedImpl(String prefix, Integer maxResults, final FileRequestOptions options, final SegmentedStorageRequest segmentedRequest) {
        Utility.assertContinuationType(segmentedRequest.getToken(), ResultContinuationType.FILE);
        final ListingContext listingContext = new ListingContext(prefix, maxResults);
        StorageRequest<CloudFileClient, CloudFileDirectory, ResultSegment<ListFileItem>> getRequest = new StorageRequest<CloudFileClient, CloudFileDirectory, ResultSegment<ListFileItem>>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(Utility.getListingLocationMode(segmentedRequest.getToken()));
            }

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFileDirectory directory, OperationContext context) throws Exception {
                listingContext.setMarker(segmentedRequest.getToken() != null ? segmentedRequest.getToken().getNextMarker() : null);
                return FileRequest.listFilesAndDirectories(directory.getTransformedAddress().getUri(this.getCurrentLocation()), options, context, listingContext, directory.getShare().snapshotID);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, context);
            }

            @Override
            public ResultSegment<ListFileItem> preProcessResponse(CloudFileDirectory directory, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }

            @Override
            public ResultSegment<ListFileItem> postProcessResponse(HttpURLConnection connection, CloudFileDirectory directory, CloudFileClient client, OperationContext context, ResultSegment<ListFileItem> storageObject) throws Exception {
                ListResponse<ListFileItem> response = FileListHandler.getFileAndDirectoryList(this.getConnection().getInputStream(), directory);
                ResultContinuation newToken = null;
                if (response.getNextMarker() != null) {
                    newToken = new ResultContinuation();
                    newToken.setNextMarker(response.getNextMarker());
                    newToken.setContinuationType(ResultContinuationType.FILE);
                    newToken.setTargetLocation(this.getResult().getTargetLocation());
                }
                ResultSegment<ListFileItem> resSegment = new ResultSegment<ListFileItem>(response.getResults(), response.getMaxResults(), newToken);
                segmentedRequest.setToken(resSegment.getContinuationToken());
                return resSegment;
            }
        };
        return getRequest;
    }

    public CloudFile getFileReference(String fileName) throws URISyntaxException, StorageException {
        Utility.assertNotNullOrEmpty("fileName", fileName);
        StorageUri subdirectoryUri = PathUtility.appendPathToUri(this.storageUri, fileName);
        return new CloudFile(subdirectoryUri, fileName, this.getShare());
    }

    public CloudFileDirectory getDirectoryReference(String itemName) throws URISyntaxException, StorageException {
        Utility.assertNotNullOrEmpty("itemName", itemName);
        StorageUri subdirectoryUri = PathUtility.appendPathToUri(this.storageUri, itemName);
        return new CloudFileDirectory(subdirectoryUri, itemName, this.getShare());
    }

    @Override
    public URI getUri() {
        return this.storageUri.getPrimaryUri();
    }

    @Override
    public final StorageUri getStorageUri() {
        return this.storageUri;
    }

    public CloudFileClient getServiceClient() {
        return this.fileServiceClient;
    }

    public String getName() {
        return this.name;
    }

    public HashMap<String, String> getMetadata() {
        return this.metadata;
    }

    public FileDirectoryProperties getProperties() {
        return this.properties;
    }

    @Override
    public CloudFileDirectory getParent() throws URISyntaxException, StorageException {
        String parentName;
        if (this.parent == null && (parentName = CloudFile.getParentNameFromURI(this.getStorageUri(), this.getShare())) != null) {
            StorageUri parentURI = PathUtility.appendPathToUri(this.getShare().getStorageUri(), parentName);
            this.parent = new CloudFileDirectory(parentURI, this.getServiceClient().getCredentials());
        }
        return this.parent;
    }

    @Override
    public CloudFileShare getShare() throws StorageException, URISyntaxException {
        if (this.share == null) {
            this.share = this.fileServiceClient.getShareReference(PathUtility.getShareNameFromUri(this.getUri(), this.fileServiceClient.isUsePathStyleUris()));
        }
        return this.share;
    }

    public void setMetadata(HashMap<String, String> metadata) {
        this.metadata = metadata;
    }

    protected final void setShare(CloudFileShare share) {
        this.share = share;
    }

    protected final void setProperties(FileDirectoryProperties properties) {
        this.properties = properties;
    }

    protected void setStorageUri(StorageUri storageUri) {
        this.storageUri = storageUri;
    }

    private void parseQueryAndVerify(StorageUri completeUri, StorageCredentials credentials) throws StorageException, URISyntaxException {
        Utility.assertNotNull("completeUri", completeUri);
        if (!completeUri.isAbsolute()) {
            throw new IllegalArgumentException(String.format("Address %s is a relative address. Only absolute addresses are permitted.", completeUri.toString()));
        }
        this.storageUri = PathUtility.stripURIQueryAndFragment(completeUri);
        StorageCredentialsSharedAccessSignature parsedCredentials = SharedAccessSignatureHelper.parseQuery(completeUri);
        if (credentials != null && parsedCredentials != null) {
            throw new IllegalArgumentException("Cannot provide credentials as part of the address and as constructor parameter. Either pass in the address or use a different constructor.");
        }
        try {
            boolean usePathStyleUris = Utility.determinePathStyleFromUri(this.storageUri.getPrimaryUri());
            this.fileServiceClient = new CloudFileClient(PathUtility.getServiceClientBaseAddress(this.getStorageUri(), usePathStyleUris), credentials != null ? credentials : parsedCredentials);
            this.name = PathUtility.getDirectoryNameFromURI(this.storageUri.getPrimaryUri(), usePathStyleUris);
        }
        catch (URISyntaxException e) {
            throw Utility.generateNewUnexpectedStorageException(e);
        }
        HashMap<String, String[]> queryParameters = PathUtility.parseQueryString(completeUri.getQuery());
        String[] snapshotIDs = queryParameters.get("sharesnapshot");
        if (snapshotIDs != null && snapshotIDs.length > 0) {
            this.getShare().snapshotID = snapshotIDs[0];
        }
    }

    private StorageUri getTransformedAddress() throws URISyntaxException, StorageException {
        return this.fileServiceClient.getCredentials().transformUri(this.storageUri);
    }
}

