/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core;

import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

public final class MarkableFileStream
extends FilterInputStream {
    private long mark = -1L;
    private FileChannel fileChannel;

    public MarkableFileStream(FileInputStream stream) {
        super(stream);
        this.fileChannel = stream.getChannel();
    }

    @Override
    public synchronized void mark(int readlimit) {
        try {
            this.mark = this.fileChannel.position();
        }
        catch (IOException e) {
            this.mark = -1L;
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.mark == -1L) {
            throw new IOException("Stream must be marked before calling reset");
        }
        this.fileChannel.position(this.mark);
    }

    @Override
    public boolean markSupported() {
        return true;
    }
}

