/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.blob;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.blob.BlockEntry;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.blob.BlockSearchMode;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.Utility;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class BlockListHandler
extends DefaultHandler {
    private final Stack<String> elementStack = new Stack();
    private StringBuilder bld = new StringBuilder();
    private final ArrayList<BlockEntry> blocks = new ArrayList();
    private BlockSearchMode searchMode;
    private String blockName;
    private Long blockSize;

    BlockListHandler() {
    }

    public static ArrayList<BlockEntry> getBlockList(InputStream streamRef) throws ParserConfigurationException, SAXException, IOException {
        SAXParser saxParser = Utility.getSAXParser();
        BlockListHandler handler = new BlockListHandler();
        saxParser.parse(streamRef, (DefaultHandler)handler);
        return handler.blocks;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.elementStack.push(localName);
        if ("UncommittedBlocks".equals(localName)) {
            this.searchMode = BlockSearchMode.UNCOMMITTED;
        } else if ("CommittedBlocks".equals(localName)) {
            this.searchMode = BlockSearchMode.COMMITTED;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String currentNode = this.elementStack.pop();
        if (!localName.equals(currentNode)) {
            throw new SAXException("The response received is invalid or improperly formatted.");
        }
        String value = this.bld.toString();
        if (value.isEmpty()) {
            value = null;
        }
        if ("Block".equals(currentNode)) {
            BlockEntry newBlock = new BlockEntry(this.blockName, this.searchMode);
            newBlock.setSize(this.blockSize);
            this.blocks.add(newBlock);
        } else if ("Name".equals(currentNode)) {
            this.blockName = value;
        } else if ("Size".equals(currentNode)) {
            this.blockSize = Long.parseLong(value);
        }
        this.bld = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.bld.append(ch, start, length);
    }
}

