/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.azure.common.hadoop;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.fs.azure.common.hadoop.HadoopFsRecoverable;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path;

@Internal
public abstract class BaseHadoopFsRecoverableFsDataOutputStream
extends RecoverableFsDataOutputStream {
    protected FileSystem fs;
    protected Path targetFile;
    protected Path tempFile;
    protected FSDataOutputStream out;
    protected long initialFileSize = 0L;

    public long getPos() throws IOException {
        return this.out.getPos();
    }

    public void write(int b) throws IOException {
        this.out.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    public void flush() throws IOException {
        this.out.hsync();
    }

    public void sync() throws IOException {
        this.out.hflush();
        this.out.hsync();
    }

    public RecoverableWriter.ResumeRecoverable persist() throws IOException {
        this.sync();
        return this.createHadoopFsRecoverable(this.getPos());
    }

    public HadoopFsRecoverable createHadoopFsRecoverable(long pos) throws IOException {
        return new HadoopFsRecoverable(this.targetFile, this.tempFile, pos + this.initialFileSize);
    }

    public abstract RecoverableFsDataOutputStream.Committer closeForCommit() throws IOException;

    public void close() throws IOException {
        this.out.close();
    }
}

