/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.functional;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UncheckedIOException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public final class FutureIO {
    private FutureIO() {
    }

    public static <T> T awaitFuture(Future<T> future) throws InterruptedIOException, IOException, RuntimeException {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException(e.toString()).initCause(e);
        }
        catch (ExecutionException e) {
            return FutureIO.raiseInnerCause(e);
        }
    }

    public static <T> T awaitFuture(Future<T> future, long timeout, TimeUnit unit) throws InterruptedIOException, IOException, RuntimeException, TimeoutException {
        try {
            return future.get(timeout, unit);
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException(e.toString()).initCause(e);
        }
        catch (ExecutionException e) {
            return FutureIO.raiseInnerCause(e);
        }
    }

    public static <T> T raiseInnerCause(ExecutionException e) throws IOException {
        throw FutureIO.unwrapInnerException(e);
    }

    public static <T> T raiseInnerCause(CompletionException e) throws IOException {
        throw FutureIO.unwrapInnerException(e);
    }

    public static IOException unwrapInnerException(Throwable e) {
        Throwable cause = e.getCause();
        if (cause instanceof IOException) {
            return (IOException)cause;
        }
        if (cause instanceof UncheckedIOException) {
            return ((UncheckedIOException)cause).getCause();
        }
        if (cause instanceof CompletionException) {
            return FutureIO.unwrapInnerException(cause);
        }
        if (cause instanceof ExecutionException) {
            return FutureIO.unwrapInnerException(cause);
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        if (cause != null) {
            return new IOException(cause);
        }
        return new IOException(e);
    }
}

