/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security;

import java.net.InetAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.SaslPropertiesResolver;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.SaslRpcServer;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IngressPortBasedResolver
extends SaslPropertiesResolver {
    public static final Logger LOG = LoggerFactory.getLogger((String)IngressPortBasedResolver.class.getName());
    static final String INGRESS_PORT_SASL_PROP_PREFIX = "ingress.port.sasl.prop";
    static final String INGRESS_PORT_SASL_CONFIGURED_PORTS = "ingress.port.sasl.configured.ports";
    private HashMap<Integer, Map<String, String>> portPropMapping;

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.portPropMapping = new HashMap();
        Collection<String> portStrings = conf.getTrimmedStringCollection(INGRESS_PORT_SASL_CONFIGURED_PORTS);
        for (String portString : portStrings) {
            int port = Integer.parseInt(portString);
            String configKey = "ingress.port.sasl.prop." + portString;
            Map<String, String> props = IngressPortBasedResolver.getSaslProperties(conf, configKey, SaslRpcServer.QualityOfProtection.PRIVACY);
            this.portPropMapping.put(port, props);
        }
        LOG.debug("Configured with port to QOP mapping as:" + this.portPropMapping);
    }

    @Override
    @VisibleForTesting
    public Map<String, String> getServerProperties(InetAddress clientAddress, int ingressPort) {
        LOG.debug("Resolving SASL properties for " + clientAddress + " " + ingressPort);
        if (!this.portPropMapping.containsKey(ingressPort)) {
            LOG.warn("An un-configured port is being requested " + ingressPort + " using default");
            return this.getDefaultProperties();
        }
        return this.portPropMapping.get(ingressPort);
    }
}

