/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.diagnostics;

import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.contracts.diagnostics.ConfigurationValidator;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidConfigurationValueException;

abstract class ConfigurationBasicValidator<T>
implements ConfigurationValidator {
    private final T defaultVal;
    private final String configKey;
    private final boolean throwIfInvalid;

    ConfigurationBasicValidator(String configKey, T defaultVal, boolean throwIfInvalid) {
        this.configKey = configKey;
        this.defaultVal = defaultVal;
        this.throwIfInvalid = throwIfInvalid;
    }

    @Override
    public T validate(String configValue) throws InvalidConfigurationValueException {
        if (configValue == null) {
            if (this.throwIfInvalid) {
                throw new InvalidConfigurationValueException(this.configKey);
            }
            return this.defaultVal;
        }
        return null;
    }

    public T getDefaultVal() {
        return this.defaultVal;
    }

    public String getConfigKey() {
        return this.configKey;
    }

    public boolean getThrowIfInvalid() {
        return this.throwIfInvalid;
    }
}

