/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.Map;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.OperationContext;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.StorageCredentialsAccountAndKey;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.StorageCredentialsSharedAccessSignature;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.StorageException;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.StorageUri;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.Base64;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.Utility;

public abstract class StorageCredentials {
    private boolean httpsOnly = false;

    protected static StorageCredentials tryParseCredentials(Map<String, String> settings) throws InvalidKeyException {
        String sasSignature;
        String accountName = settings.get("AccountName") != null ? settings.get("AccountName") : null;
        String accountKey = settings.get("AccountKey") != null ? settings.get("AccountKey") : null;
        String string = sasSignature = settings.get("SharedAccessSignature") != null ? settings.get("SharedAccessSignature") : null;
        if (accountName != null && accountKey != null && sasSignature == null) {
            if (Base64.validateIsBase64String(accountKey)) {
                return new StorageCredentialsAccountAndKey(accountName, accountKey);
            }
            throw new InvalidKeyException("Storage Key is not a valid base64 encoded string.");
        }
        if (accountKey == null && sasSignature != null) {
            return new StorageCredentialsSharedAccessSignature(sasSignature);
        }
        return null;
    }

    public static StorageCredentials tryParseCredentials(String connectionString) throws InvalidKeyException, StorageException {
        return StorageCredentials.tryParseCredentials(Utility.parseAccountString(connectionString));
    }

    public boolean isHttpsOnly() {
        return this.httpsOnly;
    }

    public String getAccountName() {
        return null;
    }

    protected void setHttpsOnly(boolean httpsOnly) {
        this.httpsOnly = httpsOnly;
    }

    public abstract String toString(boolean var1);

    public URI transformUri(URI resourceUri) throws URISyntaxException, StorageException {
        return this.transformUri(resourceUri, null);
    }

    public StorageUri transformUri(StorageUri resourceUri) throws URISyntaxException, StorageException {
        return this.transformUri(resourceUri, null);
    }

    public abstract URI transformUri(URI var1, OperationContext var2) throws URISyntaxException, StorageException;

    public abstract StorageUri transformUri(StorageUri var1, OperationContext var2) throws URISyntaxException, StorageException;
}

