/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FSDataInputStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.IOUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.Text;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.Writable;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.WritableUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.token.Token;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.thirdparty.protobuf.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class Credentials
implements Writable {
    private static final Logger LOG = LoggerFactory.getLogger(Credentials.class);
    private Map<Text, byte[]> secretKeysMap = new HashMap<Text, byte[]>();
    private Map<Text, Token<? extends TokenIdentifier>> tokenMap = new HashMap<Text, Token<? extends TokenIdentifier>>();
    private static final byte[] TOKEN_STORAGE_MAGIC = "HDTS".getBytes(StandardCharsets.UTF_8);

    public Credentials() {
    }

    public Credentials(Credentials credentials) {
        this.addAll(credentials);
    }

    public Token<? extends TokenIdentifier> getToken(Text alias) {
        return this.tokenMap.get(alias);
    }

    public void addToken(Text alias, Token<? extends TokenIdentifier> t) {
        if (t == null) {
            LOG.warn("Null token ignored for " + alias);
        } else if (this.tokenMap.put(alias, t) != null) {
            HashMap<Text, Token<? extends TokenIdentifier>> tokensToAdd = new HashMap<Text, Token<? extends TokenIdentifier>>();
            for (Map.Entry<Text, Token<? extends TokenIdentifier>> e : this.tokenMap.entrySet()) {
                Token<? extends TokenIdentifier> token = e.getValue();
                if (!token.isPrivateCloneOf(alias)) continue;
                tokensToAdd.put(e.getKey(), t.privateClone(token.getService()));
            }
            this.tokenMap.putAll(tokensToAdd);
        }
    }

    public Collection<Token<? extends TokenIdentifier>> getAllTokens() {
        return this.tokenMap.values();
    }

    public Map<Text, Token<? extends TokenIdentifier>> getTokenMap() {
        return Collections.unmodifiableMap(this.tokenMap);
    }

    public int numberOfTokens() {
        return this.tokenMap.size();
    }

    public byte[] getSecretKey(Text alias) {
        return this.secretKeysMap.get(alias);
    }

    public int numberOfSecretKeys() {
        return this.secretKeysMap.size();
    }

    public void addSecretKey(Text alias, byte[] key) {
        this.secretKeysMap.put(alias, key);
    }

    public void removeSecretKey(Text alias) {
        this.secretKeysMap.remove(alias);
    }

    public List<Text> getAllSecretKeys() {
        ArrayList<Text> list = new ArrayList<Text>();
        list.addAll(this.secretKeysMap.keySet());
        return list;
    }

    public Map<Text, byte[]> getSecretKeyMap() {
        return Collections.unmodifiableMap(this.secretKeysMap);
    }

    public static Credentials readTokenStorageFile(Path filename, Configuration conf) throws IOException {
        Credentials credentials;
        FSDataInputStream in = null;
        Credentials credentials2 = new Credentials();
        try {
            in = filename.getFileSystem(conf).open(filename);
            credentials2.readTokenStorageStream(in);
            in.close();
            credentials = credentials2;
        }
        catch (IOException ioe) {
            try {
                throw IOUtils.wrapException(filename.toString(), "Credentials.readTokenStorageFile", ioe);
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger(LOG, in);
                throw throwable;
            }
        }
        IOUtils.cleanupWithLogger(LOG, in);
        return credentials;
    }

    public static Credentials readTokenStorageFile(File filename, Configuration conf) throws IOException {
        Credentials credentials;
        DataInputStream in = null;
        Credentials credentials2 = new Credentials();
        try {
            in = new DataInputStream(new BufferedInputStream(Files.newInputStream(filename.toPath(), new OpenOption[0])));
            credentials2.readTokenStorageStream(in);
            credentials = credentials2;
        }
        catch (IOException ioe) {
            try {
                throw new IOException("Exception reading " + filename, ioe);
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger(LOG, in);
                throw throwable;
            }
        }
        IOUtils.cleanupWithLogger(LOG, in);
        return credentials;
    }

    public void readTokenStorageStream(DataInputStream in) throws IOException {
        SerializedFormat format;
        byte[] magic = new byte[TOKEN_STORAGE_MAGIC.length];
        in.readFully(magic);
        if (!Arrays.equals(magic, TOKEN_STORAGE_MAGIC)) {
            throw new IOException("Bad header found in token storage.");
        }
        try {
            format = SerializedFormat.valueOf(in.readByte());
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
        switch (format) {
            case WRITABLE: {
                this.readFields(in);
                break;
            }
            case PROTOBUF: {
                this.readProto(in);
                break;
            }
            default: {
                throw new IOException("Unsupported format " + (Object)((Object)format));
            }
        }
    }

    public void writeTokenStorageToStream(DataOutputStream os) throws IOException {
        this.writeTokenStorageToStream(os, SerializedFormat.WRITABLE);
    }

    public void writeTokenStorageToStream(DataOutputStream os, SerializedFormat format) throws IOException {
        switch (format) {
            case WRITABLE: {
                this.writeWritableOutputStream(os);
                break;
            }
            case PROTOBUF: {
                this.writeProtobufOutputStream(os);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported serialized format: " + (Object)((Object)format));
            }
        }
    }

    private void writeWritableOutputStream(DataOutputStream os) throws IOException {
        os.write(TOKEN_STORAGE_MAGIC);
        os.write(SerializedFormat.WRITABLE.value);
        this.write(os);
    }

    private void writeProtobufOutputStream(DataOutputStream os) throws IOException {
        os.write(TOKEN_STORAGE_MAGIC);
        os.write(SerializedFormat.PROTOBUF.value);
        this.writeProto(os);
    }

    public void writeTokenStorageFile(Path filename, Configuration conf) throws IOException {
        this.writeTokenStorageFile(filename, conf, SerializedFormat.WRITABLE);
    }

    public void writeTokenStorageFile(Path filename, Configuration conf, SerializedFormat format) throws IOException {
        try (FSDataOutputStream os = filename.getFileSystem(conf).create(filename);){
            this.writeTokenStorageToStream(os, format);
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt(out, this.tokenMap.size());
        for (Map.Entry<Text, Token<? extends TokenIdentifier>> entry : this.tokenMap.entrySet()) {
            entry.getKey().write(out);
            entry.getValue().write(out);
        }
        WritableUtils.writeVInt(out, this.secretKeysMap.size());
        for (Map.Entry<Text, Token<? extends TokenIdentifier>> entry : this.secretKeysMap.entrySet()) {
            entry.getKey().write(out);
            WritableUtils.writeVInt(out, ((byte[])entry.getValue()).length);
            out.write((byte[])entry.getValue());
        }
    }

    void writeProto(DataOutput out) throws IOException {
        SecurityProtos.CredentialsKVProto.Builder kv;
        SecurityProtos.CredentialsProto.Builder storage = SecurityProtos.CredentialsProto.newBuilder();
        for (Map.Entry<Text, Token<? extends TokenIdentifier>> entry : this.tokenMap.entrySet()) {
            kv = SecurityProtos.CredentialsKVProto.newBuilder().setAliasBytes(ByteString.copyFrom(entry.getKey().getBytes(), 0, entry.getKey().getLength())).setToken(ProtobufHelper.protoFromToken(entry.getValue()));
            storage.addTokens(kv.build());
        }
        for (Map.Entry<Text, Token<? extends TokenIdentifier>> entry : this.secretKeysMap.entrySet()) {
            kv = SecurityProtos.CredentialsKVProto.newBuilder().setAliasBytes(ByteString.copyFrom(entry.getKey().getBytes(), 0, entry.getKey().getLength())).setSecret(ByteString.copyFrom((byte[])entry.getValue()));
            storage.addSecrets(kv.build());
        }
        storage.build().writeDelimitedTo((DataOutputStream)out);
    }

    void readProto(DataInput in) throws IOException {
        SecurityProtos.CredentialsProto storage = SecurityProtos.CredentialsProto.parseDelimitedFrom((DataInputStream)in);
        for (SecurityProtos.CredentialsKVProto kv : storage.getTokensList()) {
            this.addToken(new Text(kv.getAliasBytes().toByteArray()), ProtobufHelper.tokenFromProto(kv.getToken()));
        }
        for (SecurityProtos.CredentialsKVProto kv : storage.getSecretsList()) {
            this.addSecretKey(new Text(kv.getAliasBytes().toByteArray()), kv.getSecret().toByteArray());
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        Text alias;
        int i;
        this.secretKeysMap.clear();
        this.tokenMap.clear();
        int size = WritableUtils.readVInt(in);
        for (i = 0; i < size; ++i) {
            alias = new Text();
            alias.readFields(in);
            Token t = new Token();
            t.readFields(in);
            this.tokenMap.put(alias, t);
        }
        size = WritableUtils.readVInt(in);
        for (i = 0; i < size; ++i) {
            alias = new Text();
            alias.readFields(in);
            int len = WritableUtils.readVInt(in);
            byte[] value = new byte[len];
            in.readFully(value);
            this.secretKeysMap.put(alias, value);
        }
    }

    public void addAll(Credentials other) {
        this.addAll(other, true);
    }

    public void mergeAll(Credentials other) {
        this.addAll(other, false);
    }

    private void addAll(Credentials other, boolean overwrite) {
        Text key;
        for (Map.Entry<Text, byte[]> entry : other.secretKeysMap.entrySet()) {
            key = entry.getKey();
            if (this.secretKeysMap.containsKey(key) && !overwrite) continue;
            this.secretKeysMap.put(key, entry.getValue());
        }
        for (Map.Entry<Text, Object> entry : other.tokenMap.entrySet()) {
            key = entry.getKey();
            if (this.tokenMap.containsKey(key) && !overwrite) continue;
            this.addToken(key, (Token)entry.getValue());
        }
    }

    public static enum SerializedFormat {
        WRITABLE(0),
        PROTOBUF(1);

        private static final SerializedFormat[] FORMATS;
        final byte value;

        private SerializedFormat(byte val) {
            this.value = val;
        }

        public static SerializedFormat valueOf(int val) {
            try {
                return FORMATS[val];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Unknown credential format: " + val);
            }
        }

        static {
            FORMATS = SerializedFormat.values();
        }
    }
}

