/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.viewfs;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.viewfs.RegexMountPointInterceptor;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.viewfs.RegexMountPointInterceptorType;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class RegexMountPointResolvedDstPathReplaceInterceptor
implements RegexMountPointInterceptor {
    private String srcRegexString;
    private String replaceString;
    private Pattern srcRegexPattern;

    RegexMountPointResolvedDstPathReplaceInterceptor(String srcRegex, String replaceString) {
        this.srcRegexString = srcRegex;
        this.replaceString = replaceString;
        this.srcRegexPattern = null;
    }

    public String getSrcRegexString() {
        return this.srcRegexString;
    }

    public String getReplaceString() {
        return this.replaceString;
    }

    public Pattern getSrcRegexPattern() {
        return this.srcRegexPattern;
    }

    @Override
    public void initialize() throws IOException {
        try {
            this.srcRegexPattern = Pattern.compile(this.srcRegexString);
        }
        catch (PatternSyntaxException ex) {
            throw new IOException("Initialize interceptor failed, srcRegx:" + this.srcRegexString, ex);
        }
    }

    @Override
    public String interceptSource(String source) {
        return source;
    }

    @Override
    public String interceptResolvedDestPathStr(String parsedDestPathStr) {
        Matcher matcher = this.srcRegexPattern.matcher(parsedDestPathStr);
        return matcher.replaceAll(this.replaceString);
    }

    @Override
    public Path interceptRemainingPath(Path remainingPath) {
        return remainingPath;
    }

    @Override
    public RegexMountPointInterceptorType getType() {
        return RegexMountPointInterceptorType.REPLACE_RESOLVED_DST_PATH;
    }

    @Override
    public String serializeToString() {
        return RegexMountPointInterceptorType.REPLACE_RESOLVED_DST_PATH.getConfigName() + ':' + this.srcRegexString + ':' + this.replaceString;
    }

    public static RegexMountPointResolvedDstPathReplaceInterceptor deserializeFromString(String serializedString) {
        String[] strings = serializedString.split(Character.toString(':'));
        if (strings.length != 3) {
            return null;
        }
        return new RegexMountPointResolvedDstPathReplaceInterceptor(strings[1], strings[2]);
    }
}

