/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.flink.fs.azure.shaded.com.fasterxml.jackson.core.JsonParseException;
import org.apache.flink.fs.azure.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.flink.fs.azure.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.fs.azure.shaded.com.fasterxml.jackson.databind.ObjectReader;
import org.apache.flink.fs.azure.shaded.org.apache.http.NameValuePair;
import org.apache.flink.fs.azure.shaded.org.apache.http.client.utils.URIBuilder;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure.AzureNativeFileSystemStore;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure.CachedSASKeyEntry;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure.CachingAuthorizer;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure.RemoteSASKeyGenerationResponse;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure.SASKeyGenerationException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure.SASKeyGeneratorImpl;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure.SecureWasbRemoteCallHelper;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure.WasbRemoteCallException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure.WasbRemoteCallHelper;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.retry.RetryUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteSASKeyGeneratorImpl
extends SASKeyGeneratorImpl {
    public static final Logger LOG = LoggerFactory.getLogger(AzureNativeFileSystemStore.class);
    private static final ObjectReader RESPONSE_READER = new ObjectMapper().readerFor(RemoteSASKeyGenerationResponse.class);
    public static final String KEY_CRED_SERVICE_URLS = "fs.azure.cred.service.urls";
    public static final String SAS_KEY_GENERATOR_HTTP_CLIENT_RETRY_POLICY_ENABLED_KEY = "fs.azure.saskeygenerator.http.retry.policy.enabled";
    public static final String SAS_KEY_GENERATOR_HTTP_CLIENT_RETRY_POLICY_SPEC_KEY = "fs.azure.saskeygenerator.http.retry.policy.spec";
    private static final String CONTAINER_SAS_OP = "GET_CONTAINER_SAS";
    private static final String BLOB_SAS_OP = "GET_RELATIVE_BLOB_SAS";
    private static final String SAS_EXPIRY_QUERY_PARAM_NAME = "sas_expiry";
    private static final String STORAGE_ACCOUNT_QUERY_PARAM_NAME = "storage_account";
    private static final String CONTAINER_QUERY_PARAM_NAME = "container";
    private static final String RELATIVE_PATH_QUERY_PARAM_NAME = "relative_path";
    private static final String SAS_KEY_GENERATOR_HTTP_CLIENT_RETRY_POLICY_SPEC_DEFAULT = "10,3,100,2";
    private static final String SASKEY_CACHEENTRY_EXPIRY_PERIOD = "fs.azure.saskey.cacheentry.expiry.period";
    private WasbRemoteCallHelper remoteCallHelper = null;
    private boolean isKerberosSupportEnabled;
    private boolean isSpnegoTokenCacheEnabled;
    private RetryPolicy retryPolicy;
    private String[] commaSeparatedUrls;
    private CachingAuthorizer<CachedSASKeyEntry, URI> cache;
    private static final int HOURS_IN_DAY = 24;
    private static final int MINUTES_IN_HOUR = 60;

    public RemoteSASKeyGeneratorImpl(Configuration conf) {
        super(conf);
    }

    public void initialize(Configuration conf) throws IOException {
        LOG.debug("Initializing RemoteSASKeyGeneratorImpl instance");
        this.retryPolicy = RetryUtils.getMultipleLinearRandomRetry(conf, SAS_KEY_GENERATOR_HTTP_CLIENT_RETRY_POLICY_ENABLED_KEY, true, SAS_KEY_GENERATOR_HTTP_CLIENT_RETRY_POLICY_SPEC_KEY, SAS_KEY_GENERATOR_HTTP_CLIENT_RETRY_POLICY_SPEC_DEFAULT);
        this.isKerberosSupportEnabled = conf.getBoolean("fs.azure.enable.kerberos.support", false);
        this.isSpnegoTokenCacheEnabled = conf.getBoolean("fs.azure.enable.spnego.token.cache", true);
        this.commaSeparatedUrls = conf.getTrimmedStrings(KEY_CRED_SERVICE_URLS);
        if (this.commaSeparatedUrls == null || this.commaSeparatedUrls.length <= 0) {
            throw new IOException("fs.azure.cred.service.urls config not set in configuration.");
        }
        this.remoteCallHelper = this.isKerberosSupportEnabled && UserGroupInformation.isSecurityEnabled() ? new SecureWasbRemoteCallHelper(this.retryPolicy, false, this.isSpnegoTokenCacheEnabled) : new WasbRemoteCallHelper(this.retryPolicy);
        long sasKeyExpiryPeriodInMinutes = this.getSasKeyExpiryPeriod() * 24L * 60L;
        long cacheEntryDurationInMinutes = conf.getTimeDuration(SASKEY_CACHEENTRY_EXPIRY_PERIOD, sasKeyExpiryPeriodInMinutes, TimeUnit.MINUTES);
        cacheEntryDurationInMinutes = cacheEntryDurationInMinutes > sasKeyExpiryPeriodInMinutes - 5L ? sasKeyExpiryPeriodInMinutes - 5L : cacheEntryDurationInMinutes;
        this.cache = new CachingAuthorizer(cacheEntryDurationInMinutes, "SASKEY");
        this.cache.init(conf);
        LOG.debug("Initialization of RemoteSASKeyGenerator instance successful");
    }

    @Override
    public URI getContainerSASUri(String storageAccount, String container) throws SASKeyGenerationException {
        RemoteSASKeyGenerationResponse sasKeyResponse = null;
        try {
            CachedSASKeyEntry cacheKey = new CachedSASKeyEntry(storageAccount, container, "/");
            URI cacheResult = this.cache.get(cacheKey);
            if (cacheResult != null) {
                return cacheResult;
            }
            LOG.debug("Generating Container SAS Key: Storage Account {}, Container {}", (Object)storageAccount, (Object)container);
            URIBuilder uriBuilder = new URIBuilder();
            uriBuilder.setPath("/GET_CONTAINER_SAS");
            uriBuilder.addParameter(STORAGE_ACCOUNT_QUERY_PARAM_NAME, storageAccount);
            uriBuilder.addParameter(CONTAINER_QUERY_PARAM_NAME, container);
            uriBuilder.addParameter(SAS_EXPIRY_QUERY_PARAM_NAME, "" + this.getSasKeyExpiryPeriod());
            sasKeyResponse = this.makeRemoteRequest(this.commaSeparatedUrls, uriBuilder.getPath(), uriBuilder.getQueryParams());
            if (sasKeyResponse.getResponseCode() == 0) {
                URI sasKey = new URI(sasKeyResponse.getSasKey());
                this.cache.put(cacheKey, sasKey);
                return sasKey;
            }
            throw new SASKeyGenerationException("Remote Service encountered error in SAS Key generation : " + sasKeyResponse.getResponseMessage());
        }
        catch (URISyntaxException uriSyntaxEx) {
            throw new SASKeyGenerationException("Encountered URISyntaxException while building the HttpGetRequest to remote service for ", uriSyntaxEx);
        }
    }

    @Override
    public URI getRelativeBlobSASUri(String storageAccount, String container, String relativePath) throws SASKeyGenerationException {
        try {
            CachedSASKeyEntry cacheKey = new CachedSASKeyEntry(storageAccount, container, relativePath);
            URI cacheResult = this.cache.get(cacheKey);
            if (cacheResult != null) {
                return cacheResult;
            }
            LOG.debug("Generating RelativePath SAS Key for relativePath {} inside Container {} inside Storage Account {}", new Object[]{relativePath, container, storageAccount});
            URIBuilder uriBuilder = new URIBuilder();
            uriBuilder.setPath("/GET_RELATIVE_BLOB_SAS");
            uriBuilder.addParameter(STORAGE_ACCOUNT_QUERY_PARAM_NAME, storageAccount);
            uriBuilder.addParameter(CONTAINER_QUERY_PARAM_NAME, container);
            uriBuilder.addParameter(RELATIVE_PATH_QUERY_PARAM_NAME, relativePath);
            uriBuilder.addParameter(SAS_EXPIRY_QUERY_PARAM_NAME, "" + this.getSasKeyExpiryPeriod());
            RemoteSASKeyGenerationResponse sasKeyResponse = this.makeRemoteRequest(this.commaSeparatedUrls, uriBuilder.getPath(), uriBuilder.getQueryParams());
            if (sasKeyResponse.getResponseCode() == 0) {
                URI sasKey = new URI(sasKeyResponse.getSasKey());
                this.cache.put(cacheKey, sasKey);
                return sasKey;
            }
            throw new SASKeyGenerationException("Remote Service encountered error in SAS Key generation : " + sasKeyResponse.getResponseMessage());
        }
        catch (URISyntaxException uriSyntaxEx) {
            throw new SASKeyGenerationException("Encountered URISyntaxException while building the HttpGetRequest to  remote service", uriSyntaxEx);
        }
    }

    private RemoteSASKeyGenerationResponse makeRemoteRequest(String[] urls, String path, List<NameValuePair> queryParams) throws SASKeyGenerationException {
        try {
            String responseBody = this.remoteCallHelper.makeRemoteRequest(urls, path, queryParams, "GET");
            return (RemoteSASKeyGenerationResponse)RESPONSE_READER.readValue(responseBody);
        }
        catch (WasbRemoteCallException remoteCallEx) {
            throw new SASKeyGenerationException("Encountered RemoteCallException while retrieving SAS key from remote service", remoteCallEx);
        }
        catch (JsonParseException jsonParserEx) {
            throw new SASKeyGenerationException("Encountered JsonParseException while parsing the response from remote service into RemoteSASKeyGenerationResponse object", jsonParserEx);
        }
        catch (JsonMappingException jsonMappingEx) {
            throw new SASKeyGenerationException("Encountered JsonMappingException while mapping the response from remote service into RemoteSASKeyGenerationResponse object", jsonMappingEx);
        }
        catch (IOException ioEx) {
            throw new SASKeyGenerationException("Encountered IOException while accessing remote service to retrieve SAS Key", ioEx);
        }
    }
}

