/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.AbfsStatistic;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidAbfsRestOperationException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services.AbfsClientThrottlingIntercept;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services.AbfsCounters;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services.AbfsHttpHeader;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services.AbfsIoUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services.AbfsRestOperationType;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbfsRestOperation {
    private final AbfsRestOperationType operationType;
    private final AbfsClient client;
    private final String method;
    private final URL url;
    private final List<AbfsHttpHeader> requestHeaders;
    private final boolean hasRequestBody;
    private final String sasToken;
    private static final Logger LOG = LoggerFactory.getLogger(AbfsClient.class);
    private byte[] buffer;
    private int bufferOffset;
    private int bufferLength;
    private int retryCount = 0;
    private AbfsHttpOperation result;
    private AbfsCounters abfsCounters;

    public boolean hasResult() {
        return this.result != null;
    }

    public AbfsHttpOperation getResult() {
        return this.result;
    }

    public void hardSetResult(int httpStatus) {
        this.result = AbfsHttpOperation.getAbfsHttpOperationWithFixedResult(this.url, this.method, httpStatus);
    }

    public URL getUrl() {
        return this.url;
    }

    public List<AbfsHttpHeader> getRequestHeaders() {
        return this.requestHeaders;
    }

    public boolean isARetriedRequest() {
        return this.retryCount > 0;
    }

    String getSasToken() {
        return this.sasToken;
    }

    AbfsRestOperation(AbfsRestOperationType operationType, AbfsClient client, String method, URL url, List<AbfsHttpHeader> requestHeaders) {
        this(operationType, client, method, url, requestHeaders, null);
    }

    AbfsRestOperation(AbfsRestOperationType operationType, AbfsClient client, String method, URL url, List<AbfsHttpHeader> requestHeaders, String sasToken) {
        this.operationType = operationType;
        this.client = client;
        this.method = method;
        this.url = url;
        this.requestHeaders = requestHeaders;
        this.hasRequestBody = "PUT".equals(method) || "POST".equals(method) || "PATCH".equals(method);
        this.sasToken = sasToken;
        this.abfsCounters = client.getAbfsCounters();
    }

    AbfsRestOperation(AbfsRestOperationType operationType, AbfsClient client, String method, URL url, List<AbfsHttpHeader> requestHeaders, byte[] buffer, int bufferOffset, int bufferLength, String sasToken) {
        this(operationType, client, method, url, requestHeaders, sasToken);
        this.buffer = buffer;
        this.bufferOffset = bufferOffset;
        this.bufferLength = bufferLength;
        this.abfsCounters = client.getAbfsCounters();
    }

    public void execute(TracingContext tracingContext) throws AzureBlobFileSystemException {
        try {
            IOStatisticsBinding.trackDurationOfInvocation(this.abfsCounters, AbfsStatistic.getStatNameFromHttpCall(this.method), () -> this.completeExecute(tracingContext));
        }
        catch (AzureBlobFileSystemException aze) {
            throw aze;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error while tracking Duration of an AbfsRestOperation call", e);
        }
    }

    private void completeExecute(TracingContext tracingContext) throws AzureBlobFileSystemException {
        String latencyHeader = this.client.getAbfsPerfTracker().getClientLatency();
        if (latencyHeader != null && !latencyHeader.isEmpty()) {
            AbfsHttpHeader httpHeader = new AbfsHttpHeader("x-ms-abfs-client-latency", latencyHeader);
            this.requestHeaders.add(httpHeader);
        }
        this.retryCount = 0;
        LOG.debug("First execution of REST operation - {}", (Object)this.operationType);
        while (!this.executeHttpOperation(this.retryCount, tracingContext)) {
            try {
                ++this.retryCount;
                tracingContext.setRetryCount(this.retryCount);
                LOG.debug("Retrying REST operation {}. RetryCount = {}", (Object)this.operationType, (Object)this.retryCount);
                Thread.sleep(this.client.getRetryPolicy().getRetryInterval(this.retryCount));
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.result.getStatusCode() >= 400) {
            throw new AbfsRestOperationException(this.result.getStatusCode(), this.result.getStorageErrorCode(), this.result.getStorageErrorMessage(), null, this.result);
        }
        LOG.trace("{} REST operation complete", (Object)this.operationType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeHttpOperation(int retryCount, TracingContext tracingContext) throws AzureBlobFileSystemException {
        AbfsHttpOperation httpOperation = null;
        try {
            httpOperation = new AbfsHttpOperation(this.url, this.method, this.requestHeaders);
            this.incrementCounter(AbfsStatistic.CONNECTIONS_MADE, 1L);
            tracingContext.constructHeader(httpOperation);
            switch (this.client.getAuthType()) {
                case Custom: 
                case OAuth: {
                    LOG.debug("Authenticating request with OAuth2 access token");
                    httpOperation.getConnection().setRequestProperty("Authorization", this.client.getAccessToken());
                    break;
                }
                case SAS: {
                    httpOperation.setMaskForSAS();
                    break;
                }
                case SharedKey: {
                    LOG.debug("Signing request with shared key");
                    this.client.getSharedKeyCredentials().signRequest(httpOperation.getConnection(), this.hasRequestBody ? (long)this.bufferLength : 0L);
                }
            }
        }
        catch (IOException e) {
            LOG.debug("Auth failure: {}, {}", (Object)this.method, (Object)this.url);
            throw new AbfsRestOperationException(-1, null, "Auth failure: " + e.getMessage(), e);
        }
        try {
            AbfsIoUtils.dumpHeadersToDebugLog("Request Headers", httpOperation.getConnection().getRequestProperties());
            AbfsClientThrottlingIntercept.sendingRequest(this.operationType, this.abfsCounters);
            if (this.hasRequestBody) {
                httpOperation.sendRequest(this.buffer, this.bufferOffset, this.bufferLength);
                this.incrementCounter(AbfsStatistic.SEND_REQUESTS, 1L);
                this.incrementCounter(AbfsStatistic.BYTES_SENT, this.bufferLength);
            }
            httpOperation.processResponse(this.buffer, this.bufferOffset, this.bufferLength);
            this.incrementCounter(AbfsStatistic.GET_RESPONSES, 1L);
            if (httpOperation.getStatusCode() >= 200 && httpOperation.getStatusCode() <= 206) {
                this.incrementCounter(AbfsStatistic.BYTES_RECEIVED, httpOperation.getBytesReceived());
            } else if (httpOperation.getStatusCode() == 503) {
                this.incrementCounter(AbfsStatistic.SERVER_UNAVAILABLE, 1L);
            }
        }
        catch (UnknownHostException ex) {
            String hostname = null;
            hostname = httpOperation.getHost();
            LOG.warn("Unknown host name: %s. Retrying to resolve the host name...", (Object)hostname);
            if (!this.client.getRetryPolicy().shouldRetry(retryCount, -1)) {
                throw new InvalidAbfsRestOperationException(ex);
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("HttpRequestFailure: {}, {}", (Object)httpOperation.toString(), (Object)ex);
            }
            if (!this.client.getRetryPolicy().shouldRetry(retryCount, -1)) {
                throw new InvalidAbfsRestOperationException(ex);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            AbfsClientThrottlingIntercept.updateMetrics(this.operationType, httpOperation);
        }
        LOG.debug("HttpRequest: {}: {}", (Object)this.operationType, (Object)httpOperation.toString());
        if (this.client.getRetryPolicy().shouldRetry(retryCount, httpOperation.getStatusCode())) {
            return false;
        }
        this.result = httpOperation;
        return true;
    }

    private void incrementCounter(AbfsStatistic statistic, long value) {
        if (this.abfsCounters != null) {
            this.abfsCounters.incrementCounter(statistic, value);
        }
    }
}

