/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.activation.UnsupportedDataTypeException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileStatus;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.RemoteIterator;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services.ListingSupport;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbfsListStatusRemoteIterator
implements RemoteIterator<FileStatus> {
    private static final Logger LOG = LoggerFactory.getLogger(AbfsListStatusRemoteIterator.class);
    private static final boolean FETCH_ALL_FALSE = false;
    private static final int MAX_QUEUE_SIZE = 10;
    private static final long POLL_WAIT_TIME_IN_MS = 250L;
    private final FileStatus fileStatus;
    private final ListingSupport listingSupport;
    private final ArrayBlockingQueue<Object> iteratorsQueue;
    private final TracingContext tracingContext;
    private volatile boolean isAsyncInProgress = false;
    private boolean isIterationComplete = false;
    private String continuation;
    private Iterator<FileStatus> currIterator;

    public AbfsListStatusRemoteIterator(FileStatus fileStatus, ListingSupport listingSupport, TracingContext tracingContext) {
        this.fileStatus = fileStatus;
        this.listingSupport = listingSupport;
        this.tracingContext = tracingContext;
        this.iteratorsQueue = new ArrayBlockingQueue(10);
        this.currIterator = Collections.emptyIterator();
        this.fetchBatchesAsync();
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.currIterator.hasNext()) {
            return true;
        }
        this.currIterator = this.getNextIterator();
        return this.currIterator.hasNext();
    }

    @Override
    public FileStatus next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.currIterator.next();
    }

    private Iterator<FileStatus> getNextIterator() throws IOException {
        this.fetchBatchesAsync();
        try {
            Object obj = null;
            while (!(obj != null || this.isIterationComplete && this.iteratorsQueue.isEmpty())) {
                obj = this.iteratorsQueue.poll(250L, TimeUnit.MILLISECONDS);
            }
            if (obj == null) {
                return Collections.emptyIterator();
            }
            if (obj instanceof Iterator) {
                return (Iterator)obj;
            }
            if (obj instanceof IOException) {
                throw (IOException)obj;
            }
            throw new UnsupportedDataTypeException();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("Thread got interrupted: {}", (Throwable)e);
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchBatchesAsync() {
        if (this.isAsyncInProgress || this.isIterationComplete) {
            return;
        }
        AbfsListStatusRemoteIterator abfsListStatusRemoteIterator = this;
        synchronized (abfsListStatusRemoteIterator) {
            if (this.isAsyncInProgress || this.isIterationComplete) {
                return;
            }
            this.isAsyncInProgress = true;
        }
        CompletableFuture.runAsync(() -> this.asyncOp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncOp() {
        try {
            while (!this.isIterationComplete && this.iteratorsQueue.size() <= 10) {
                this.addNextBatchIteratorToQueue();
            }
        }
        catch (IOException ioe) {
            LOG.error("Fetching filestatuses failed", (Throwable)ioe);
            try {
                this.iteratorsQueue.put(ioe);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                LOG.error("Thread got interrupted: {}", (Throwable)interruptedException);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("Thread got interrupted: {}", (Throwable)e);
        }
        finally {
            AbfsListStatusRemoteIterator ioe = this;
            synchronized (ioe) {
                this.isAsyncInProgress = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNextBatchIteratorToQueue() throws IOException, InterruptedException {
        ArrayList<FileStatus> fileStatuses = new ArrayList<FileStatus>();
        this.continuation = this.listingSupport.listStatus(this.fileStatus.getPath(), null, fileStatuses, false, this.continuation, this.tracingContext);
        if (!fileStatuses.isEmpty()) {
            this.iteratorsQueue.put(fileStatuses.iterator());
        }
        AbfsListStatusRemoteIterator abfsListStatusRemoteIterator = this;
        synchronized (abfsListStatusRemoteIterator) {
            if (this.continuation == null || this.continuation.isEmpty()) {
                this.isIterationComplete = true;
            }
        }
    }
}

