/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure;

import java.util.concurrent.TimeUnit;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.thirdparty.com.google.common.cache.Cache;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.thirdparty.com.google.common.cache.CacheBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingAuthorizer<K, V> {
    public static final Logger LOG = LoggerFactory.getLogger(CachingAuthorizer.class);
    private Cache<K, V> cache;
    private boolean isEnabled = false;
    private long cacheEntryExpiryPeriodInMinutes;
    private String label;
    public static final String KEY_AUTH_SERVICE_CACHING_ENABLE = "fs.azure.authorization.caching.enable";
    public static final boolean KEY_AUTH_SERVICE_CACHING_ENABLE_DEFAULT = false;
    public static final String KEY_AUTH_SERVICE_CACHING_MAX_ENTRIES = "fs.azure.authorization.caching.maxentries";
    public static final int KEY_AUTH_SERVICE_CACHING_MAX_ENTRIES_DEFAULT = 512;

    public CachingAuthorizer(long ttlInMinutes, String label) {
        this.cacheEntryExpiryPeriodInMinutes = ttlInMinutes;
        this.label = label;
        if (this.cacheEntryExpiryPeriodInMinutes <= 0L) {
            this.isEnabled = false;
        }
    }

    public void init(Configuration conf) {
        this.isEnabled = conf.getBoolean(KEY_AUTH_SERVICE_CACHING_ENABLE, false);
        if (this.isEnabled) {
            LOG.debug("{} : Initializing CachingAuthorizer instance", (Object)this.label);
            this.cache = CacheBuilder.newBuilder().maximumSize(conf.getInt(KEY_AUTH_SERVICE_CACHING_MAX_ENTRIES, 512)).expireAfterWrite(this.cacheEntryExpiryPeriodInMinutes, TimeUnit.MINUTES).build();
        }
    }

    public V get(K key) {
        if (!this.isEnabled) {
            return null;
        }
        V result = this.cache.getIfPresent(key);
        if (result == null) {
            LOG.debug("{}: CACHE MISS: {}", (Object)this.label, (Object)key.toString());
        } else {
            LOG.debug("{}: CACHE HIT: {}, {}", new Object[]{this.label, key.toString(), result.toString()});
        }
        return result;
    }

    public void put(K key, V value) {
        if (this.isEnabled) {
            LOG.debug("{}: CACHE PUT: {}, {}", new Object[]{this.label, key.toString(), value.toString()});
            this.cache.put(key, value);
        }
    }

    public void clear() {
        if (this.isEnabled) {
            this.cache.invalidateAll();
        }
    }
}

