/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.security;

import java.io.IOException;
import org.apache.flink.fs.azure.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.extensions.CustomDelegationTokenManager;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.security.AbfsDelegationTokenIdentifier;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.token.Token;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbfsDelegationTokenManager {
    private CustomDelegationTokenManager tokenManager;
    private static final Logger LOG = LoggerFactory.getLogger(AbfsDelegationTokenManager.class);

    public AbfsDelegationTokenManager(Configuration conf) throws IOException {
        Preconditions.checkNotNull(conf, "conf");
        Class<CustomDelegationTokenManager> customDelegationTokenMgrClass = conf.getClass("fs.azure.delegation.token.provider.type", null, CustomDelegationTokenManager.class);
        if (customDelegationTokenMgrClass == null) {
            throw new IllegalArgumentException("The value for \"fs.azure.delegation.token.provider.type\" is not defined.");
        }
        CustomDelegationTokenManager customTokenMgr = ReflectionUtils.newInstance(customDelegationTokenMgrClass, conf);
        if (customTokenMgr == null) {
            throw new IllegalArgumentException(String.format("Failed to initialize %s.", customDelegationTokenMgrClass));
        }
        customTokenMgr.initialize(conf);
        this.tokenManager = customTokenMgr;
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(String renewer) throws IOException {
        Token<DelegationTokenIdentifier> token = this.tokenManager.getDelegationToken(renewer);
        token.setKind(AbfsDelegationTokenIdentifier.TOKEN_KIND);
        return token;
    }

    public long renewDelegationToken(Token<?> token) throws IOException {
        return this.tokenManager.renewDelegationToken(token);
    }

    public void cancelDelegationToken(Token<?> token) throws IOException {
        this.tokenManager.cancelDelegationToken(token);
    }
}

