/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.SharedAccessPolicy;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.Utility;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SharedAccessPolicyHandler<T extends SharedAccessPolicy>
extends DefaultHandler {
    private final Stack<String> elementStack = new Stack();
    private StringBuilder bld = new StringBuilder();
    private final HashMap<String, T> policies = new HashMap();
    private final Class<T> policyClassType;
    private String id;
    private T policy;

    private SharedAccessPolicyHandler(Class<T> cls) {
        this.policyClassType = cls;
    }

    public static <T extends SharedAccessPolicy> HashMap<String, T> getAccessIdentifiers(InputStream stream, Class<T> cls) throws ParserConfigurationException, SAXException, IOException {
        SAXParser saxParser = Utility.getSAXParser();
        SharedAccessPolicyHandler<T> handler = new SharedAccessPolicyHandler<T>(cls);
        saxParser.parse(stream, handler);
        return handler.policies;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.elementStack.push(localName);
        if ("SignedIdentifier".equals(localName)) {
            this.id = null;
            try {
                this.policy = (SharedAccessPolicy)this.policyClassType.newInstance();
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String currentNode = this.elementStack.pop();
        if (!localName.equals(currentNode)) {
            throw new SAXException("The response received is invalid or improperly formatted.");
        }
        String value = this.bld.toString();
        if (value.isEmpty()) {
            value = null;
        }
        if ("SignedIdentifier".equals(currentNode)) {
            this.policies.put(this.id, this.policy);
        } else if ("Id".equals(currentNode)) {
            this.id = value;
        } else if ("Start".equals(currentNode)) {
            try {
                ((SharedAccessPolicy)this.policy).setSharedAccessStartTime(Utility.parseDate(value));
            }
            catch (IllegalArgumentException e) {
                throw new SAXException(e);
            }
        } else if ("Expiry".equals(currentNode)) {
            try {
                ((SharedAccessPolicy)this.policy).setSharedAccessExpiryTime(Utility.parseDate(value));
            }
            catch (IllegalArgumentException e) {
                throw new SAXException(e);
            }
        } else if ("Permission".equals(currentNode)) {
            ((SharedAccessPolicy)this.policy).setPermissionsFromString(value);
        }
        this.bld = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.bld.append(ch, start, length);
    }
}

