/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services;

import java.util.concurrent.CountDownLatch;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.contracts.services.ReadBufferStatus;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services.ReadBuffer;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services.ReadBufferManager;

class ReadBufferWorker
implements Runnable {
    protected static final CountDownLatch UNLEASH_WORKERS = new CountDownLatch(1);
    private int id;

    ReadBufferWorker(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public void run() {
        try {
            UNLEASH_WORKERS.await();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        ReadBufferManager bufferManager = ReadBufferManager.getBufferManager();
        while (true) {
            ReadBuffer buffer;
            try {
                buffer = bufferManager.getNextBlockToRead();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                return;
            }
            if (buffer == null) continue;
            try {
                int bytesRead = buffer.getStream().readRemote(buffer.getOffset(), buffer.getBuffer(), 0, buffer.getRequestedLength());
                bufferManager.doneReading(buffer, ReadBufferStatus.AVAILABLE, bytesRead);
                continue;
            }
            catch (Exception ex) {
                bufferManager.doneReading(buffer, ReadBufferStatus.READ_FAILED, 0);
                continue;
            }
            break;
        }
    }
}

