/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure.security;

import java.io.IOException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure.security.RemoteWasbDelegationTokenManager;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure.security.WasbDelegationTokenIdentifier;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure.security.WasbDelegationTokenManager;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.Text;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.token.Token;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.token.TokenRenewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WasbTokenRenewer
extends TokenRenewer {
    public static final Logger LOG = LoggerFactory.getLogger(WasbTokenRenewer.class);

    @Override
    public boolean handleKind(Text kind) {
        return WasbDelegationTokenIdentifier.TOKEN_KIND.equals(kind);
    }

    @Override
    public boolean isManaged(Token<?> token) throws IOException {
        return true;
    }

    @Override
    public long renew(Token<?> token, Configuration conf) throws IOException, InterruptedException {
        LOG.debug("Renewing the delegation token");
        return this.getInstance(conf).renewDelegationToken(token);
    }

    @Override
    public void cancel(Token<?> token, Configuration conf) throws IOException, InterruptedException {
        LOG.debug("Cancelling the delegation token");
        this.getInstance(conf).cancelDelegationToken(token);
    }

    private WasbDelegationTokenManager getInstance(Configuration conf) throws IOException {
        return new RemoteWasbDelegationTokenManager(conf);
    }
}

