/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services;

import java.time.Instant;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.contracts.services.AbfsPerfLoggable;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services.AbfsPerfTracker;

public final class AbfsPerfInfo
implements AutoCloseable {
    private AbfsPerfTracker abfsPerfTracker;
    private String callerName;
    private String calleeName;
    private Instant trackingStart;
    private Instant trackingEnd;
    private boolean success;
    private Instant aggregateStart;
    private long aggregateCount;
    private AbfsPerfLoggable res;

    public AbfsPerfInfo(AbfsPerfTracker abfsPerfTracker, String callerName, String calleeName) {
        this.callerName = callerName;
        this.calleeName = calleeName;
        this.abfsPerfTracker = abfsPerfTracker;
        this.success = false;
        this.trackingStart = abfsPerfTracker.getLatencyInstant();
    }

    public AbfsPerfInfo registerSuccess(boolean success) {
        this.success = success;
        return this;
    }

    public AbfsPerfInfo registerResult(AbfsPerfLoggable res) {
        this.res = res;
        return this;
    }

    public AbfsPerfInfo registerAggregates(Instant aggregateStart, long aggregateCount) {
        this.aggregateStart = aggregateStart;
        this.aggregateCount = aggregateCount;
        return this;
    }

    public AbfsPerfInfo finishTracking() {
        if (this.trackingEnd == null) {
            this.trackingEnd = this.abfsPerfTracker.getLatencyInstant();
        }
        return this;
    }

    public AbfsPerfInfo registerCallee(String calleeName) {
        this.calleeName = calleeName;
        return this;
    }

    @Override
    public void close() {
        this.abfsPerfTracker.trackInfo(this.finishTracking());
    }

    public String getCallerName() {
        return this.callerName;
    }

    public String getCalleeName() {
        return this.calleeName;
    }

    public Instant getTrackingStart() {
        return this.trackingStart;
    }

    public Instant getTrackingEnd() {
        return this.trackingEnd;
    }

    public boolean getSuccess() {
        return this.success;
    }

    public Instant getAggregateStart() {
        return this.aggregateStart;
    }

    public long getAggregateCount() {
        return this.aggregateCount;
    }

    public AbfsPerfLoggable getResult() {
        return this.res;
    }
}

