/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.fs.azure.shaded.com.google.common.util.concurrent.ForwardingExecutorService;
import org.apache.flink.fs.azure.shaded.com.google.common.util.concurrent.Futures;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class SemaphoredDelegatingExecutor
extends ForwardingExecutorService {
    private final Semaphore queueingPermits;
    private final ExecutorService executorDelegatee;
    private final int permitCount;

    public SemaphoredDelegatingExecutor(ExecutorService executorDelegatee, int permitCount, boolean fair) {
        this.permitCount = permitCount;
        this.queueingPermits = new Semaphore(permitCount, fair);
        this.executorDelegatee = executorDelegatee;
    }

    @Override
    protected ExecutorService delegate() {
        return this.executorDelegatee;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        try {
            this.queueingPermits.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Futures.immediateFailedFuture(e);
        }
        return super.submit(new CallableWithPermitRelease<T>(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        try {
            this.queueingPermits.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Futures.immediateFailedFuture(e);
        }
        return super.submit(new RunnableWithPermitRelease(task), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        try {
            this.queueingPermits.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Futures.immediateFailedFuture(e);
        }
        return super.submit(new RunnableWithPermitRelease(task));
    }

    @Override
    public void execute(Runnable command) {
        try {
            this.queueingPermits.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        super.execute(new RunnableWithPermitRelease(command));
    }

    public int getAvailablePermits() {
        return this.queueingPermits.availablePermits();
    }

    public int getWaitingCount() {
        return this.queueingPermits.getQueueLength();
    }

    public int getPermitCount() {
        return this.permitCount;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SemaphoredDelegatingExecutor{");
        sb.append("permitCount=").append(this.getPermitCount()).append(", available=").append(this.getAvailablePermits()).append(", waiting=").append(this.getWaitingCount()).append('}');
        return sb.toString();
    }

    class CallableWithPermitRelease<T>
    implements Callable<T> {
        private Callable<T> delegatee;

        CallableWithPermitRelease(Callable<T> delegatee) {
            this.delegatee = delegatee;
        }

        @Override
        public T call() throws Exception {
            try {
                T t = this.delegatee.call();
                return t;
            }
            finally {
                SemaphoredDelegatingExecutor.this.queueingPermits.release();
            }
        }
    }

    class RunnableWithPermitRelease
    implements Runnable {
        private Runnable delegatee;

        RunnableWithPermitRelease(Runnable delegatee) {
            this.delegatee = delegatee;
        }

        @Override
        public void run() {
            try {
                this.delegatee.run();
            }
            finally {
                SemaphoredDelegatingExecutor.this.queueingPermits.release();
            }
        }
    }
}

