/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.file.tfile;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FSDataInputStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.IOUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.file.tfile.BCFile;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.file.tfile.Compression;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.file.tfile.TFile;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.file.tfile.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TFileDumper {
    static final Logger LOG = LoggerFactory.getLogger(TFileDumper.class);

    private TFileDumper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpInfo(String file, PrintStream out, Configuration conf) throws IOException {
        int maxKeySampleLen = 16;
        Path path = new Path(file);
        FileSystem fs = path.getFileSystem(conf);
        long length = fs.getFileStatus(path).getLen();
        FSDataInputStream fsdis = fs.open(path);
        TFile.Reader reader = new TFile.Reader(fsdis, length, conf);
        try {
            LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
            int blockCnt = reader.readerBCF.getBlockCount();
            int metaBlkCnt = reader.readerBCF.metaIndex.index.size();
            properties.put("BCFile Version", reader.readerBCF.version.toString());
            properties.put("TFile Version", reader.tfileMeta.version.toString());
            properties.put("File Length", Long.toString(length));
            properties.put("Data Compression", reader.readerBCF.getDefaultCompressionName());
            properties.put("Record Count", Long.toString(reader.getEntryCount()));
            properties.put("Sorted", Boolean.toString(reader.isSorted()));
            if (reader.isSorted()) {
                properties.put("Comparator", reader.getComparatorName());
            }
            properties.put("Data Block Count", Integer.toString(blockCnt));
            long dataSize = 0L;
            long dataSizeUncompressed = 0L;
            if (blockCnt > 0) {
                for (int i = 0; i < blockCnt; ++i) {
                    BCFile.BlockRegion region = reader.readerBCF.dataIndex.getBlockRegionList().get(i);
                    dataSize += region.getCompressedSize();
                    dataSizeUncompressed += region.getRawSize();
                }
                properties.put("Data Block Bytes", Long.toString(dataSize));
                if (!reader.readerBCF.getDefaultCompressionName().equals("none")) {
                    properties.put("Data Block Uncompressed Bytes", Long.toString(dataSizeUncompressed));
                    properties.put("Data Block Compression Ratio", String.format("1:%.1f", (double)dataSizeUncompressed / (double)dataSize));
                }
            }
            properties.put("Meta Block Count", Integer.toString(metaBlkCnt));
            long metaSize = 0L;
            long metaSizeUncompressed = 0L;
            if (metaBlkCnt > 0) {
                Collection<BCFile.MetaIndexEntry> metaBlks = reader.readerBCF.metaIndex.index.values();
                boolean calculateCompression = false;
                for (BCFile.MetaIndexEntry e : metaBlks) {
                    metaSize += e.getRegion().getCompressedSize();
                    metaSizeUncompressed += e.getRegion().getRawSize();
                    if (e.getCompressionAlgorithm() == Compression.Algorithm.NONE) continue;
                    calculateCompression = true;
                }
                properties.put("Meta Block Bytes", Long.toString(metaSize));
                if (calculateCompression) {
                    properties.put("Meta Block Uncompressed Bytes", Long.toString(metaSizeUncompressed));
                    properties.put("Meta Block Compression Ratio", String.format("1:%.1f", (double)metaSizeUncompressed / (double)metaSize));
                }
            }
            properties.put("Meta-Data Size Ratio", String.format("1:%.1f", (double)dataSize / (double)metaSize));
            long leftOverBytes = length - dataSize - metaSize;
            long miscSize = BCFile.Magic.size() * 2 + 8 + Utils.Version.size();
            long metaIndexSize = leftOverBytes - miscSize;
            properties.put("Meta Block Index Bytes", Long.toString(metaIndexSize));
            properties.put("Headers Etc Bytes", Long.toString(miscSize));
            int maxKeyLength = 0;
            Set entrySet = properties.entrySet();
            for (Map.Entry e : entrySet) {
                if (((String)e.getKey()).length() <= maxKeyLength) continue;
                maxKeyLength = ((String)e.getKey()).length();
            }
            for (Map.Entry e : entrySet) {
                out.printf("%s : %s%n", Align.format((String)e.getKey(), maxKeyLength, Align.LEFT), e.getValue());
            }
            out.println();
            reader.checkTFileDataIndex();
            if (blockCnt > 0) {
                String blkID = "Data-Block";
                int blkIDWidth = Align.calculateWidth(blkID, blockCnt);
                int blkIDWidth2 = Align.calculateWidth("", blockCnt);
                String offset = "Offset";
                int offsetWidth = Align.calculateWidth(offset, length);
                String blkLen = "Length";
                int blkLenWidth = Align.calculateWidth(blkLen, dataSize / (long)blockCnt * 10L);
                String rawSize = "Raw-Size";
                int rawSizeWidth = Align.calculateWidth(rawSize, dataSizeUncompressed / (long)blockCnt * 10L);
                String records = "Records";
                int recordsWidth = Align.calculateWidth(records, reader.getEntryCount() / (long)blockCnt * 10L);
                String endKey = "End-Key";
                int endKeyWidth = Math.max(endKey.length(), 37);
                out.printf("%s %s %s %s %s %s%n", Align.format(blkID, blkIDWidth, Align.CENTER), Align.format(offset, offsetWidth, Align.CENTER), Align.format(blkLen, blkLenWidth, Align.CENTER), Align.format(rawSize, rawSizeWidth, Align.CENTER), Align.format(records, recordsWidth, Align.CENTER), Align.format(endKey, endKeyWidth, Align.LEFT));
                for (int i = 0; i < blockCnt; ++i) {
                    byte b;
                    int j;
                    BCFile.BlockRegion region = reader.readerBCF.dataIndex.getBlockRegionList().get(i);
                    TFile.TFileIndexEntry indexEntry = reader.tfileIndex.getEntry(i);
                    out.printf("%s %s %s %s %s ", Align.format(Align.format(i, blkIDWidth2, Align.ZERO_PADDED), blkIDWidth, Align.LEFT), Align.format(region.getOffset(), offsetWidth, Align.LEFT), Align.format(region.getCompressedSize(), blkLenWidth, Align.LEFT), Align.format(region.getRawSize(), rawSizeWidth, Align.LEFT), Align.format(indexEntry.kvEntries, recordsWidth, Align.LEFT));
                    byte[] key = indexEntry.key;
                    boolean asAscii = true;
                    int sampleLen = Math.min(16, key.length);
                    for (j = 0; j < sampleLen; ++j) {
                        b = key[j];
                        if ((b >= 32 || b == 9) && b != 127) continue;
                        asAscii = false;
                    }
                    if (!asAscii) {
                        out.print("0X");
                        for (j = 0; j < sampleLen; ++j) {
                            b = key[i];
                            out.printf("%X", b);
                        }
                    } else {
                        out.print(new String(key, 0, sampleLen, StandardCharsets.UTF_8));
                    }
                    if (sampleLen < key.length) {
                        out.print("...");
                    }
                    out.println();
                }
            }
            out.println();
            if (metaBlkCnt > 0) {
                String name = "Meta-Block";
                int maxNameLen = 0;
                Set<Map.Entry<String, BCFile.MetaIndexEntry>> metaBlkEntrySet = reader.readerBCF.metaIndex.index.entrySet();
                for (Map.Entry<String, BCFile.MetaIndexEntry> e : metaBlkEntrySet) {
                    if (e.getKey().length() <= maxNameLen) continue;
                    maxNameLen = e.getKey().length();
                }
                int nameWidth = Math.max(name.length(), maxNameLen);
                String offset = "Offset";
                int offsetWidth = Align.calculateWidth(offset, length);
                String blkLen = "Length";
                int blkLenWidth = Align.calculateWidth(blkLen, metaSize / (long)metaBlkCnt * 10L);
                String rawSize = "Raw-Size";
                int rawSizeWidth = Align.calculateWidth(rawSize, metaSizeUncompressed / (long)metaBlkCnt * 10L);
                String compression = "Compression";
                int compressionWidth = compression.length();
                out.printf("%s %s %s %s %s%n", Align.format(name, nameWidth, Align.CENTER), Align.format(offset, offsetWidth, Align.CENTER), Align.format(blkLen, blkLenWidth, Align.CENTER), Align.format(rawSize, rawSizeWidth, Align.CENTER), Align.format(compression, compressionWidth, Align.LEFT));
                for (Map.Entry<String, BCFile.MetaIndexEntry> e : metaBlkEntrySet) {
                    String blkName = e.getValue().getMetaName();
                    BCFile.BlockRegion region = e.getValue().getRegion();
                    String blkCompression = e.getValue().getCompressionAlgorithm().getName();
                    out.printf("%s %s %s %s %s%n", Align.format(blkName, nameWidth, Align.LEFT), Align.format(region.getOffset(), offsetWidth, Align.LEFT), Align.format(region.getCompressedSize(), blkLenWidth, Align.LEFT), Align.format(region.getRawSize(), rawSizeWidth, Align.LEFT), Align.format(blkCompression, compressionWidth, Align.LEFT));
                }
            }
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger(LOG, reader, fsdis);
            throw throwable;
        }
        IOUtils.cleanupWithLogger(LOG, reader, fsdis);
    }

    private static enum Align {
        LEFT,
        CENTER,
        RIGHT,
        ZERO_PADDED;


        static String format(String s2, int width, Align align) {
            if (s2.length() >= width) {
                return s2;
            }
            int room = width - s2.length();
            Align alignAdjusted = align;
            if (room == 1) {
                alignAdjusted = LEFT;
            }
            if (alignAdjusted == LEFT) {
                return s2 + String.format("%" + room + "s", "");
            }
            if (alignAdjusted == RIGHT) {
                return String.format("%" + room + "s", "") + s2;
            }
            if (alignAdjusted == CENTER) {
                int half = room / 2;
                return String.format("%" + half + "s", "") + s2 + String.format("%" + (room - half) + "s", "");
            }
            throw new IllegalArgumentException("Unsupported alignment");
        }

        static String format(long l, int width, Align align) {
            if (align == ZERO_PADDED) {
                return String.format("%0" + width + "d", l);
            }
            return Align.format(Long.toString(l), width, align);
        }

        static int calculateWidth(String caption, long max) {
            return Math.max(caption.length(), Long.toString(max).length());
        }
    }
}

