/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.contracts.exceptions.KeyProviderException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services.SimpleKeyProvider;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellDecryptionKeyProvider
extends SimpleKeyProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ShellDecryptionKeyProvider.class);

    @Override
    public String getStorageAccountKey(String accountName, Configuration rawConfig) throws KeyProviderException {
        AbfsConfiguration abfsConfig;
        String envelope = super.getStorageAccountKey(accountName, rawConfig);
        try {
            abfsConfig = new AbfsConfiguration(rawConfig, accountName);
        }
        catch (IOException | IllegalAccessException e) {
            throw new KeyProviderException("Unable to get key from credential providers.", (Throwable)e);
        }
        String command = abfsConfig.get("fs.azure.shellkeyprovider.script");
        if (command == null) {
            throw new KeyProviderException("Script path is not specified via fs.azure.shellkeyprovider.script");
        }
        String[] cmd = command.split(" ");
        String[] cmdWithEnvelope = Arrays.copyOf(cmd, cmd.length + 1);
        cmdWithEnvelope[cmdWithEnvelope.length - 1] = envelope;
        String decryptedKey = null;
        try {
            decryptedKey = Shell.execCommand(cmdWithEnvelope);
        }
        catch (IOException ex) {
            throw new KeyProviderException(ex);
        }
        return decryptedKey.trim();
    }
}

