/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure;

import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileStatus;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure.BlobMaterialization;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.permission.PermissionStatus;

@InterfaceAudience.Private
class FileMetadata
extends FileStatus {
    private String key;
    private final BlobMaterialization blobMaterialization;

    public FileMetadata(String key, long length, long lastModified, PermissionStatus permissionStatus, long blockSize) {
        super(length, false, 1, blockSize, lastModified, 0L, permissionStatus.getPermission(), permissionStatus.getUserName(), permissionStatus.getGroupName(), null);
        this.key = key;
        this.blobMaterialization = BlobMaterialization.Explicit;
    }

    public FileMetadata(String key, long lastModified, PermissionStatus permissionStatus, BlobMaterialization blobMaterialization, long blockSize) {
        super(0L, true, 1, blockSize, lastModified, 0L, permissionStatus.getPermission(), permissionStatus.getUserName(), permissionStatus.getGroupName(), null);
        this.key = key;
        this.blobMaterialization = blobMaterialization;
    }

    @Override
    public Path getPath() {
        Path p = super.getPath();
        if (p == null) {
            p = NativeAzureFileSystem.keyToPath(this.key);
        }
        return p;
    }

    public String getKey() {
        return this.key;
    }

    public BlobMaterialization getBlobMaterialization() {
        return this.blobMaterialization;
    }

    void removeKey() {
        this.key = null;
    }
}

