/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.flink.fs.azure.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.crypto.CipherSuite;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.crypto.CryptoCodec;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.crypto.UnsupportedCodecException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Seekable;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.CleanerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class CryptoStreamUtils {
    private static final int MIN_BUFFER_SIZE = 512;
    private static final Logger LOG = LoggerFactory.getLogger(CryptoStreamUtils.class);

    public static void freeDB(ByteBuffer buffer) {
        if (CleanerUtil.UNMAP_SUPPORTED) {
            try {
                CleanerUtil.getCleaner().freeBuffer(buffer);
            }
            catch (IOException e) {
                LOG.info("Failed to free the buffer", (Throwable)e);
            }
        } else {
            LOG.trace(CleanerUtil.UNMAP_NOT_SUPPORTED_REASON);
        }
    }

    public static int getBufferSize(Configuration conf) {
        return conf.getInt("hadoop.security.crypto.buffer.size", 8192);
    }

    public static void checkCodec(CryptoCodec codec) {
        if (codec.getCipherSuite() != CipherSuite.AES_CTR_NOPADDING) {
            throw new UnsupportedCodecException("AES/CTR/NoPadding is required");
        }
    }

    public static int checkBufferSize(CryptoCodec codec, int bufferSize) {
        Preconditions.checkArgument(bufferSize >= 512, "Minimum value of buffer size is 512.");
        return bufferSize - bufferSize % codec.getCipherSuite().getAlgorithmBlockSize();
    }

    public static long getInputStreamOffset(InputStream in) throws IOException {
        if (in instanceof Seekable) {
            return ((Seekable)((Object)in)).getPos();
        }
        return 0L;
    }
}

