/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table;

import java.security.Key;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.keyvault.core.IKey;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.keyvault.core.IKeyResolver;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.StorageException;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.EncryptionAgent;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.EncryptionAlgorithm;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.EncryptionData;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.Utility;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.WrappedContentKey;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table.CEKReturn;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table.EdmType;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table.EntityProperty;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.table.TableRequestOptions;
import org.apache.flink.fs.shaded.hadoop3.org.apache.commons.lang3.tuple.Pair;

public class TableEncryptionPolicy {
    public IKey keyWrapper;
    public IKeyResolver keyResolver;

    public TableEncryptionPolicy(IKey key, IKeyResolver keyResolver) {
        this.keyWrapper = key;
        this.keyResolver = keyResolver;
    }

    public IKey getKey() {
        return this.keyWrapper;
    }

    public IKeyResolver getKeyResolver() {
        return this.keyResolver;
    }

    public void setKey(IKey key) {
        this.keyWrapper = key;
    }

    public void setKeyResolver(IKeyResolver keyResolver) {
        this.keyResolver = keyResolver;
    }

    Map<String, EntityProperty> encryptEntity(Map<String, EntityProperty> properties, String partitionKey, String rowKey, TableRequestOptions.EncryptionResolver encryptionResolver) throws StorageException {
        Utility.assertNotNull("properties", properties);
        if (this.keyWrapper == null) {
            throw new IllegalArgumentException("Key is not initialized. Encryption requires it to be initialized.");
        }
        EncryptionData encryptionData = new EncryptionData();
        if (encryptionData.getKeyWrappingMetadata() == null) {
            encryptionData.setKeyWrappingMetadata(new HashMap<String, String>());
        }
        encryptionData.getKeyWrappingMetadata().put("EncryptionLibrary", "Java 7.0.0");
        encryptionData.setEncryptionAgent(new EncryptionAgent("1.0", EncryptionAlgorithm.AES_CBC_256));
        try {
            HashMap<String, EntityProperty> encryptedProperties = new HashMap<String, EntityProperty>();
            HashSet<String> encryptionPropertyDetailsSet = new HashSet<String>();
            KeyGenerator keyGen = KeyGenerator.getInstance("AES");
            keyGen.init(256);
            Cipher myAes = Cipher.getInstance("AES/CBC/PKCS5Padding");
            SecretKey aesKey = keyGen.generateKey();
            myAes.init(1, aesKey);
            Pair encryptedKey = (Pair)this.keyWrapper.wrapKeyAsync(aesKey.getEncoded(), null).get();
            encryptionData.setWrappedContentKey(new WrappedContentKey(this.keyWrapper.getKid(), (byte[])encryptedKey.getKey(), (String)encryptedKey.getValue()));
            encryptionData.setContentEncryptionIV(myAes.getIV());
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            for (Map.Entry<String, EntityProperty> kvp : properties.entrySet()) {
                byte[] dest;
                byte[] src;
                if (encryptionResolver != null && encryptionResolver.encryptionResolver(partitionKey, rowKey, kvp.getKey())) {
                    if (kvp.getValue() == null) {
                        throw new IllegalArgumentException("Null properties cannot be encrypted. Please assign a default value to the property if you wish to encrypt it.");
                    }
                    kvp.getValue().setIsEncrypted(true);
                }
                if (kvp.getValue() != null && kvp.getValue().isEncrypted()) {
                    if (kvp.getValue().getEdmType() != EdmType.STRING) {
                        throw new IllegalArgumentException(String.format("Unsupported type : %s encountered during encryption. Only string properties can be encrypted on the client side.", new Object[]{kvp.getValue().getEdmType()}));
                    }
                    byte[] columnIVFull = digest.digest(Utility.binaryAppend(encryptionData.getContentEncryptionIV(), (partitionKey + rowKey + kvp.getKey()).getBytes("UTF-8")));
                    byte[] columnIV = new byte[16];
                    System.arraycopy(columnIVFull, 0, columnIV, 0, 16);
                    myAes.init(1, (Key)aesKey, new IvParameterSpec(columnIV));
                    if (kvp.getValue() == null) {
                        throw new IllegalArgumentException("Null properties cannot be encrypted. Please assign a default value to the property if you wish to encrypt it.");
                    }
                    src = kvp.getValue().getValueAsString().getBytes("UTF-8");
                    dest = myAes.doFinal(src, 0, src.length);
                    encryptedProperties.put(kvp.getKey(), new EntityProperty(dest));
                    encryptionPropertyDetailsSet.add(kvp.getKey());
                } else {
                    encryptedProperties.put(kvp.getKey(), kvp.getValue());
                }
                byte[] metadataIVFull = digest.digest(Utility.binaryAppend(encryptionData.getContentEncryptionIV(), (partitionKey + rowKey + "_ClientEncryptionMetadata2").getBytes("UTF-8")));
                byte[] metadataIV = new byte[16];
                System.arraycopy(metadataIVFull, 0, metadataIV, 0, 16);
                myAes.init(1, (Key)aesKey, new IvParameterSpec(metadataIV));
                src = Arrays.toString(encryptionPropertyDetailsSet.toArray()).getBytes("UTF-8");
                dest = myAes.doFinal(src, 0, src.length);
                encryptedProperties.put("_ClientEncryptionMetadata2", new EntityProperty(dest));
            }
            encryptedProperties.put("_ClientEncryptionMetadata1", new EntityProperty(encryptionData.serialize()));
            return encryptedProperties;
        }
        catch (Exception e) {
            throw StorageException.translateClientException(e);
        }
    }

    CEKReturn decryptMetadataAndReturnCEK(String partitionKey, String rowKey, EntityProperty encryptionKeyProperty, EntityProperty propertyDetailsProperty, EncryptionData encryptionData) throws StorageException {
        if (this.keyWrapper == null && this.keyResolver == null) {
            throw new StorageException("DecryptionError", "Key and Resolver are not initialized. Decryption requires either of them to be initialized.", null);
        }
        try {
            encryptionData.copyValues(EncryptionData.deserialize(encryptionKeyProperty.getValueAsString()));
            Utility.assertNotNull("contentEncryptionIV", encryptionData.getContentEncryptionIV());
            Utility.assertNotNull("encryptedKey", encryptionData.getWrappedContentKey().getEncryptedKey());
            if (!"1.0".equals(encryptionData.getEncryptionAgent().getProtocol())) {
                throw new StorageException("DecryptionError", "Invalid Encryption Agent. This version of the client library does not understand the Encryption Agent set on the blob.", null);
            }
            Boolean isJavaV1 = encryptionData.getEncryptionAgent().getProtocol().equals("1.0") && (encryptionData.getKeyWrappingMetadata() == null || encryptionData.getKeyWrappingMetadata().containsKey("EncryptionLibrary") && encryptionData.getKeyWrappingMetadata().get("EncryptionLibrary").contains("Java"));
            byte[] contentEncryptionKey = null;
            if (this.keyResolver != null) {
                IKey keyEncryptionKey = (IKey)this.keyResolver.resolveKeyAsync(encryptionData.getWrappedContentKey().getKeyId()).get();
                Utility.assertNotNull("keyEncryptionKey", keyEncryptionKey);
                contentEncryptionKey = (byte[])keyEncryptionKey.unwrapKeyAsync(encryptionData.getWrappedContentKey().getEncryptedKey(), encryptionData.getWrappedContentKey().getAlgorithm()).get();
            } else if (encryptionData.getWrappedContentKey().getKeyId().equals(this.keyWrapper.getKid())) {
                contentEncryptionKey = (byte[])this.keyWrapper.unwrapKeyAsync(encryptionData.getWrappedContentKey().getEncryptedKey(), encryptionData.getWrappedContentKey().getAlgorithm()).get();
            } else {
                throw new StorageException("DecryptionError", "Key mismatch. The key id stored on the service does not match the specified key.", null);
            }
            Cipher myAes = Cipher.getInstance("AES/CBC/PKCS5Padding");
            MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
            String IVString = isJavaV1 != false ? partitionKey + rowKey + "_ClientEncryptionMetadata2" : rowKey + partitionKey + "_ClientEncryptionMetadata2";
            byte[] metadataIVFull = sha256.digest(Utility.binaryAppend(encryptionData.getContentEncryptionIV(), IVString.getBytes("UTF-8")));
            byte[] metadataIV = new byte[16];
            System.arraycopy(metadataIVFull, 0, metadataIV, 0, 16);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(metadataIV);
            SecretKeySpec keySpec = new SecretKeySpec(contentEncryptionKey, 0, contentEncryptionKey.length, "AES");
            myAes.init(2, (Key)keySpec, ivParameterSpec);
            byte[] src = propertyDetailsProperty.getValueAsByteArray();
            propertyDetailsProperty.setValue(myAes.doFinal(src, 0, src.length));
            CEKReturn ret = new CEKReturn();
            ret.key = keySpec;
            ret.isJavaV1 = isJavaV1;
            return ret;
        }
        catch (StorageException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new StorageException("DecryptionError", "Decryption logic threw error. Please check the inner exception for more details.", ex);
        }
    }

    HashMap<String, EntityProperty> decryptEntity(HashMap<String, EntityProperty> properties, HashSet<String> encryptedPropertyDetailsSet, String partitionKey, String rowKey, Key contentEncryptionKey, EncryptionData encryptionData, Boolean isJavaV1) throws StorageException {
        HashMap<String, EntityProperty> decryptedProperties = new HashMap<String, EntityProperty>();
        try {
            switch (encryptionData.getEncryptionAgent().getEncryptionAlgorithm()) {
                case AES_CBC_256: {
                    Cipher myAes = Cipher.getInstance("AES/CBC/PKCS5Padding");
                    for (Map.Entry<String, EntityProperty> kvp : properties.entrySet()) {
                        if (kvp.getKey() == "_ClientEncryptionMetadata1" || kvp.getKey() == "_ClientEncryptionMetadata2") continue;
                        if (encryptedPropertyDetailsSet.contains(kvp.getKey())) {
                            MessageDigest digest = MessageDigest.getInstance("SHA-256");
                            String IVString = isJavaV1 != false ? partitionKey + rowKey + kvp.getKey() : rowKey + partitionKey + kvp.getKey();
                            byte[] columnIVFull = digest.digest(Utility.binaryAppend(encryptionData.getContentEncryptionIV(), IVString.getBytes("UTF-8")));
                            byte[] columnIV = new byte[16];
                            System.arraycopy(columnIVFull, 0, columnIV, 0, 16);
                            myAes.init(2, contentEncryptionKey, new IvParameterSpec(columnIV));
                            byte[] src = kvp.getValue().getValueAsByteArray();
                            byte[] dest = myAes.doFinal(src, 0, src.length);
                            String destString = new String(dest, "UTF-8");
                            decryptedProperties.put(kvp.getKey(), new EntityProperty(destString));
                            continue;
                        }
                        decryptedProperties.put(kvp.getKey(), kvp.getValue());
                    }
                    return decryptedProperties;
                }
            }
            throw new StorageException("DecryptionError", "Invalid Encryption Algorithm found on the resource. This version of the client library does not support the specified encryption algorithm.", null);
        }
        catch (StorageException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new StorageException("DecryptionError", "Decryption logic threw error. Please check the inner exception for more details.", ex);
        }
    }
}

