/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.curator;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.AuthInfo;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.api.PathAndBytesable;
import org.apache.curator.framework.api.WatchPathable;
import org.apache.curator.framework.api.transaction.CuratorTransaction;
import org.apache.curator.framework.api.transaction.CuratorTransactionBridge;
import org.apache.curator.framework.api.transaction.CuratorTransactionFinal;
import org.apache.curator.retry.RetryNTimes;
import org.apache.flink.fs.azure.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.SecurityUtil;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.ZKUtil;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class ZKCuratorManager {
    private static final Logger LOG = LoggerFactory.getLogger(ZKCuratorManager.class);
    private final Configuration conf;
    private CuratorFramework curator;

    public ZKCuratorManager(Configuration config) throws IOException {
        this.conf = config;
    }

    public CuratorFramework getCurator() {
        return this.curator;
    }

    public void close() {
        if (this.curator != null) {
            this.curator.close();
        }
    }

    public static List<ACL> getZKAcls(Configuration conf) throws IOException {
        String zkAclConf = conf.get("hadoop.zk.acl", "world:anyone:rwcda");
        try {
            zkAclConf = ZKUtil.resolveConfIndirection(zkAclConf);
            return ZKUtil.parseACLs(zkAclConf);
        }
        catch (IOException | ZKUtil.BadAclFormatException e) {
            LOG.error("Couldn't read ACLs based on {}", (Object)"hadoop.zk.acl");
            throw e;
        }
    }

    public static List<ZKUtil.ZKAuthInfo> getZKAuths(Configuration conf) throws IOException {
        return SecurityUtil.getZKAuthInfos(conf, "hadoop.zk.auth");
    }

    public void start() throws IOException {
        this.start(new ArrayList<AuthInfo>());
    }

    public void start(List<AuthInfo> authInfos) throws IOException {
        String zkHostPort = this.conf.get("hadoop.zk.address");
        if (zkHostPort == null) {
            throw new IOException("hadoop.zk.address is not configured.");
        }
        int numRetries = this.conf.getInt("hadoop.zk.num-retries", 1000);
        int zkSessionTimeout = this.conf.getInt("hadoop.zk.timeout-ms", 10000);
        int zkRetryInterval = this.conf.getInt("hadoop.zk.retry-interval-ms", 1000);
        RetryNTimes retryPolicy = new RetryNTimes(numRetries, zkRetryInterval);
        List<ZKUtil.ZKAuthInfo> zkAuths = ZKCuratorManager.getZKAuths(this.conf);
        if (authInfos == null) {
            authInfos = new ArrayList<AuthInfo>();
        }
        for (ZKUtil.ZKAuthInfo zkAuth : zkAuths) {
            authInfos.add(new AuthInfo(zkAuth.getScheme(), zkAuth.getAuth()));
        }
        CuratorFramework client = CuratorFrameworkFactory.builder().connectString(zkHostPort).sessionTimeoutMs(zkSessionTimeout).retryPolicy((RetryPolicy)retryPolicy).authorization(authInfos).build();
        client.start();
        this.curator = client;
    }

    public List<ACL> getACL(String path) throws Exception {
        return (List)this.curator.getACL().forPath(path);
    }

    public byte[] getData(String path) throws Exception {
        return (byte[])this.curator.getData().forPath(path);
    }

    public byte[] getData(String path, Stat stat) throws Exception {
        return (byte[])((WatchPathable)this.curator.getData().storingStatIn(stat)).forPath(path);
    }

    public String getStringData(String path) throws Exception {
        byte[] bytes = this.getData(path);
        if (bytes != null) {
            return new String(bytes, Charset.forName("UTF-8"));
        }
        return null;
    }

    public String getStringData(String path, Stat stat) throws Exception {
        byte[] bytes = this.getData(path, stat);
        if (bytes != null) {
            return new String(bytes, Charset.forName("UTF-8"));
        }
        return null;
    }

    public void setData(String path, byte[] data, int version) throws Exception {
        ((BackgroundPathAndBytesable)this.curator.setData().withVersion(version)).forPath(path, data);
    }

    public void setData(String path, String data, int version) throws Exception {
        byte[] bytes = data.getBytes(Charset.forName("UTF-8"));
        this.setData(path, bytes, version);
    }

    public List<String> getChildren(String path) throws Exception {
        return (List)this.curator.getChildren().forPath(path);
    }

    public boolean exists(String path) throws Exception {
        return this.curator.checkExists().forPath(path) != null;
    }

    public boolean create(String path) throws Exception {
        return this.create(path, null);
    }

    public boolean create(String path, List<ACL> zkAcl) throws Exception {
        boolean created = false;
        if (!this.exists(path)) {
            ((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)this.curator.create().withMode(CreateMode.PERSISTENT)).withACL(zkAcl)).forPath(path, null);
            created = true;
        }
        return created;
    }

    public void createRootDirRecursively(String path) throws Exception {
        this.createRootDirRecursively(path, null);
    }

    public void createRootDirRecursively(String path, List<ACL> zkAcl) throws Exception {
        String[] pathParts = path.split("/");
        Preconditions.checkArgument(pathParts.length >= 1 && pathParts[0].isEmpty(), "Invalid path: %s", (Object)path);
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < pathParts.length; ++i) {
            sb.append("/").append(pathParts[i]);
            this.create(sb.toString(), zkAcl);
        }
    }

    public boolean delete(String path) throws Exception {
        if (this.exists(path)) {
            this.curator.delete().deletingChildrenIfNeeded().forPath(path);
            return true;
        }
        return false;
    }

    public static String getNodePath(String root, String nodeName) {
        return root + "/" + nodeName;
    }

    public void safeCreate(String path, byte[] data, List<ACL> acl, CreateMode mode, List<ACL> fencingACL, String fencingNodePath) throws Exception {
        if (!this.exists(path)) {
            SafeTransaction transaction = this.createTransaction(fencingACL, fencingNodePath);
            transaction.create(path, data, acl, mode);
            transaction.commit();
        }
    }

    public void safeDelete(String path, List<ACL> fencingACL, String fencingNodePath) throws Exception {
        if (this.exists(path)) {
            SafeTransaction transaction = this.createTransaction(fencingACL, fencingNodePath);
            transaction.delete(path);
            transaction.commit();
        }
    }

    public void safeSetData(String path, byte[] data, int version, List<ACL> fencingACL, String fencingNodePath) throws Exception {
        SafeTransaction transaction = this.createTransaction(fencingACL, fencingNodePath);
        transaction.setData(path, data, version);
        transaction.commit();
    }

    public SafeTransaction createTransaction(List<ACL> fencingACL, String fencingNodePath) throws Exception {
        return new SafeTransaction(fencingACL, fencingNodePath);
    }

    public class SafeTransaction {
        private CuratorTransactionFinal transactionFinal;
        private String fencingNodePath;

        SafeTransaction(List<ACL> fencingACL, String fencingNodePath) throws Exception {
            this.fencingNodePath = fencingNodePath;
            CuratorTransaction transaction = ZKCuratorManager.this.curator.inTransaction();
            this.transactionFinal = ((CuratorTransactionBridge)((PathAndBytesable)((ACLPathAndBytesable)transaction.create().withMode(CreateMode.PERSISTENT)).withACL(fencingACL)).forPath(fencingNodePath, new byte[0])).and();
        }

        public void commit() throws Exception {
            this.transactionFinal = ((CuratorTransactionBridge)this.transactionFinal.delete().forPath(this.fencingNodePath)).and();
            this.transactionFinal.commit();
        }

        public void create(String path, byte[] data, List<ACL> acl, CreateMode mode) throws Exception {
            this.transactionFinal = ((CuratorTransactionBridge)((PathAndBytesable)((ACLPathAndBytesable)this.transactionFinal.create().withMode(mode)).withACL(acl)).forPath(path, data)).and();
        }

        public void delete(String path) throws Exception {
            this.transactionFinal = ((CuratorTransactionBridge)this.transactionFinal.delete().forPath(path)).and();
        }

        public void setData(String path, byte[] data, int version) throws Exception {
            this.transactionFinal = ((CuratorTransactionBridge)((PathAndBytesable)this.transactionFinal.setData().withVersion(version)).forPath(path, data)).and();
        }
    }
}

