/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.metrics2;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.flink.fs.shaded.hadoop3.org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.metrics2.MetricsTag;
import org.apache.flink.fs.shaded.hadoop3.org.codehaus.jackson.map.ObjectMapper;
import org.apache.flink.fs.shaded.hadoop3.org.codehaus.jackson.map.ObjectWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MetricsJsonBuilder
extends MetricsRecordBuilder {
    public static final Logger LOG = LoggerFactory.getLogger(MetricsRecordBuilder.class);
    private final MetricsCollector parent;
    private Map<String, Object> innerMetrics = new LinkedHashMap<String, Object>();
    private static final ObjectWriter WRITER = new ObjectMapper().writer();

    public MetricsJsonBuilder(MetricsCollector parent) {
        this.parent = parent;
    }

    private MetricsRecordBuilder tuple(String key, Object value) {
        this.innerMetrics.put(key, value);
        return this;
    }

    @Override
    public MetricsRecordBuilder tag(MetricsInfo info, String value) {
        return this.tuple(info.name(), value);
    }

    @Override
    public MetricsRecordBuilder add(MetricsTag tag) {
        return this.tuple(tag.name(), tag.value());
    }

    @Override
    public MetricsRecordBuilder add(AbstractMetric metric) {
        return this.tuple(metric.info().name(), metric.toString());
    }

    @Override
    public MetricsRecordBuilder setContext(String value) {
        return this.tuple("context", value);
    }

    @Override
    public MetricsRecordBuilder addCounter(MetricsInfo info, int value) {
        return this.tuple(info.name(), value);
    }

    @Override
    public MetricsRecordBuilder addCounter(MetricsInfo info, long value) {
        return this.tuple(info.name(), value);
    }

    @Override
    public MetricsRecordBuilder addGauge(MetricsInfo info, int value) {
        return this.tuple(info.name(), value);
    }

    @Override
    public MetricsRecordBuilder addGauge(MetricsInfo info, long value) {
        return this.tuple(info.name(), value);
    }

    @Override
    public MetricsRecordBuilder addGauge(MetricsInfo info, float value) {
        return this.tuple(info.name(), Float.valueOf(value));
    }

    @Override
    public MetricsRecordBuilder addGauge(MetricsInfo info, double value) {
        return this.tuple(info.name(), value);
    }

    @Override
    public MetricsCollector parent() {
        return this.parent;
    }

    public String toString() {
        try {
            return WRITER.writeValueAsString(this.innerMetrics);
        }
        catch (IOException e) {
            LOG.warn("Failed to dump to Json.", (Throwable)e);
            return ExceptionUtils.getStackTrace(e);
        }
    }
}

