/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.blob;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.StorageException;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.blob.BlobContainerAttributes;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.blob.BlobContainerPublicAccessType;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.blob.CloudBlobClient;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.blob.CloudBlobContainer;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.blob.LeaseDuration;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.blob.LeaseState;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.blob.LeaseStatus;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.ListResponse;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.Utility;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class ContainerListHandler
extends DefaultHandler {
    private final Stack<String> elementStack = new Stack();
    private StringBuilder bld = new StringBuilder();
    private final CloudBlobClient serviceClient;
    private final ListResponse<CloudBlobContainer> response = new ListResponse();
    private BlobContainerAttributes attributes;
    private String containerName;

    private ContainerListHandler(CloudBlobClient serviceClient) {
        this.serviceClient = serviceClient;
    }

    protected static ListResponse<CloudBlobContainer> getContainerList(InputStream stream, CloudBlobClient serviceClient) throws ParserConfigurationException, SAXException, IOException {
        SAXParser saxParser = Utility.getSAXParser();
        ContainerListHandler handler = new ContainerListHandler(serviceClient);
        saxParser.parse(stream, (DefaultHandler)handler);
        return handler.response;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.elementStack.push(localName);
        if ("Container".equals(localName)) {
            this.containerName = "";
            this.attributes = new BlobContainerAttributes();
            this.attributes.getProperties().setPublicAccess(BlobContainerPublicAccessType.OFF);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String value;
        String currentNode = this.elementStack.pop();
        if (!localName.equals(currentNode)) {
            throw new SAXException("The response received is invalid or improperly formatted.");
        }
        String parentNode = null;
        if (!this.elementStack.isEmpty()) {
            parentNode = this.elementStack.peek();
        }
        if ((value = this.bld.toString()).isEmpty()) {
            value = null;
        }
        if ("Container".equals(currentNode)) {
            try {
                CloudBlobContainer retContainer = this.serviceClient.getContainerReference(this.containerName);
                retContainer.setMetadata(this.attributes.getMetadata());
                retContainer.setProperties(this.attributes.getProperties());
                this.response.getResults().add(retContainer);
            }
            catch (URISyntaxException e) {
                throw new SAXException(e);
            }
            catch (StorageException e) {
                throw new SAXException(e);
            }
        } else if ("EnumerationResults".equals(parentNode)) {
            if ("Prefix".equals(currentNode)) {
                this.response.setPrefix(value);
            } else if ("Marker".equals(currentNode)) {
                this.response.setMarker(value);
            } else if ("NextMarker".equals(currentNode)) {
                this.response.setNextMarker(value);
            } else if ("MaxResults".equals(currentNode)) {
                this.response.setMaxResults(Integer.parseInt(value));
            }
        } else if ("Container".equals(parentNode)) {
            if ("Name".equals(currentNode)) {
                this.containerName = value;
            }
        } else if ("Properties".equals(parentNode)) {
            try {
                this.getProperties(currentNode, value);
            }
            catch (ParseException e) {
                throw new SAXException(e);
            }
        } else if ("Metadata".equals(parentNode)) {
            if (value == null) {
                value = "";
            }
            this.attributes.getMetadata().put(currentNode, value);
        }
        this.bld = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.bld.append(ch, start, length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getProperties(String currentNode, String value) throws ParseException, SAXException {
        if (currentNode.equals("Last-Modified")) {
            this.attributes.getProperties().setLastModified(Utility.parseRFC1123DateFromStringInGMT(value));
            return;
        } else if (currentNode.equals("Etag")) {
            this.attributes.getProperties().setEtag(Utility.formatETag(value));
            return;
        } else if (currentNode.equals("LeaseStatus")) {
            LeaseStatus tempStatus = LeaseStatus.parse(value);
            if (tempStatus.equals((Object)LeaseStatus.UNSPECIFIED)) throw new SAXException("The response received is invalid or improperly formatted.");
            this.attributes.getProperties().setLeaseStatus(tempStatus);
            return;
        } else if (currentNode.equals("LeaseState")) {
            LeaseState tempState = LeaseState.parse(value);
            if (tempState.equals((Object)LeaseState.UNSPECIFIED)) throw new SAXException("The response received is invalid or improperly formatted.");
            this.attributes.getProperties().setLeaseState(tempState);
            return;
        } else if (currentNode.equals("LeaseDuration")) {
            LeaseDuration tempDuration = LeaseDuration.parse(value);
            if (tempDuration.equals((Object)LeaseDuration.UNSPECIFIED)) throw new SAXException("The response received is invalid or improperly formatted.");
            this.attributes.getProperties().setLeaseDuration(tempDuration);
            return;
        } else {
            if (!currentNode.equals("PublicAccess")) return;
            BlobContainerPublicAccessType tempAccessType = BlobContainerPublicAccessType.parse(value);
            if (tempAccessType.equals((Object)BlobContainerPublicAccessType.OFF)) throw new SAXException("The response received is invalid or improperly formatted.");
            this.attributes.getProperties().setPublicAccess(tempAccessType);
        }
    }
}

