/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.crypto.key;

import java.io.IOException;
import org.apache.flink.fs.azure.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.crypto.key.KeyProviderExtension;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.Credentials;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.token.DelegationTokenIssuer;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.token.Token;

public class KeyProviderDelegationTokenExtension
extends KeyProviderExtension<DelegationTokenExtension>
implements DelegationTokenIssuer {
    private static DelegationTokenExtension DEFAULT_EXTENSION = new DefaultDelegationTokenExtension();

    private KeyProviderDelegationTokenExtension(KeyProvider keyProvider, DelegationTokenExtension extensions) {
        super(keyProvider, extensions);
    }

    @Override
    public String getCanonicalServiceName() {
        return ((DelegationTokenExtension)this.getExtension()).getCanonicalServiceName();
    }

    @Override
    public Token<?> getDelegationToken(String renewer) throws IOException {
        return ((DelegationTokenExtension)this.getExtension()).getDelegationToken(renewer);
    }

    public static KeyProviderDelegationTokenExtension createKeyProviderDelegationTokenExtension(KeyProvider keyProvider) {
        DelegationTokenExtension delTokExtension = keyProvider instanceof DelegationTokenExtension ? (DelegationTokenExtension)((Object)keyProvider) : DEFAULT_EXTENSION;
        return new KeyProviderDelegationTokenExtension(keyProvider, delTokExtension);
    }

    private static class DefaultDelegationTokenExtension
    implements DelegationTokenExtension {
        private DefaultDelegationTokenExtension() {
        }

        @Override
        public Token<?>[] addDelegationTokens(String renewer, Credentials credentials) {
            return null;
        }

        @Override
        public String getCanonicalServiceName() {
            return null;
        }

        @Override
        public Token<?> getDelegationToken(String renewer) {
            return null;
        }

        @Override
        public long renewDelegationToken(Token<?> token) throws IOException {
            return 0L;
        }

        @Override
        public Void cancelDelegationToken(Token<?> token) throws IOException {
            return null;
        }

        @Override
        public Token<?> selectDelegationToken(Credentials creds) {
            return null;
        }
    }

    public static interface DelegationTokenExtension
    extends KeyProviderExtension.Extension,
    DelegationTokenIssuer {
        public long renewDelegationToken(Token<?> var1) throws IOException;

        public Void cancelDelegationToken(Token<?> var1) throws IOException;

        @InterfaceAudience.Private
        @InterfaceStability.Unstable
        @VisibleForTesting
        public Token<?> selectDelegationToken(Credentials var1);
    }
}

