/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.oauth2;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class QueryParams {
    private Map<String, String> params = new HashMap<String, String>();
    private String apiVersion = null;
    private String separator = "";
    private String serializedString = null;

    public void add(String name, String value) {
        this.params.put(name, value);
        this.serializedString = null;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        this.serializedString = null;
    }

    public String serialize() {
        if (this.serializedString == null) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : this.params.entrySet()) {
                String name = entry.getKey();
                try {
                    sb.append(this.separator);
                    sb.append(URLEncoder.encode(name, "UTF-8"));
                    sb.append('=');
                    sb.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
                    this.separator = "&";
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
            if (this.apiVersion != null) {
                sb.append(this.separator);
                sb.append("api-version=");
                sb.append(this.apiVersion);
                this.separator = "&";
            }
            this.serializedString = sb.toString();
        }
        return this.serializedString;
    }
}

