/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.authentication.util;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import javax.servlet.ServletException;

public class CertificateUtil {
    private static final String PEM_HEADER = "-----BEGIN CERTIFICATE-----\n";
    private static final String PEM_FOOTER = "\n-----END CERTIFICATE-----";

    public static RSAPublicKey parseRSAPublicKey(String pem) throws ServletException {
        String fullPem = PEM_HEADER + pem + PEM_FOOTER;
        PublicKey key = null;
        try {
            CertificateFactory fact = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream is = new ByteArrayInputStream(fullPem.getBytes("UTF8"));
            X509Certificate cer = (X509Certificate)fact.generateCertificate(is);
            key = cer.getPublicKey();
        }
        catch (CertificateException ce) {
            String message = null;
            message = pem.startsWith(PEM_HEADER) ? "CertificateException - be sure not to include PEM header and footer in the PEM configuration element." : "CertificateException - PEM may be corrupt";
            throw new ServletException(message, (Throwable)ce);
        }
        catch (UnsupportedEncodingException uee) {
            throw new ServletException((Throwable)uee);
        }
        return (RSAPublicKey)key;
    }
}

