/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azure.metrics;

import java.util.ArrayDeque;
import java.util.Date;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
final class RollingWindowAverage {
    private final ArrayDeque<DataPoint> currentPoints = new ArrayDeque();
    private final long windowSizeMs;

    public RollingWindowAverage(long windowSizeMs) {
        this.windowSizeMs = windowSizeMs;
    }

    public synchronized void addPoint(long value) {
        this.currentPoints.offer(new DataPoint(new Date(), value));
        this.cleanupOldPoints();
    }

    public synchronized long getCurrentAverage() {
        this.cleanupOldPoints();
        if (this.currentPoints.isEmpty()) {
            return 0L;
        }
        long sum = 0L;
        for (DataPoint current : this.currentPoints) {
            sum += current.getValue();
        }
        return sum / (long)this.currentPoints.size();
    }

    private void cleanupOldPoints() {
        Date cutoffTime = new Date(new Date().getTime() - this.windowSizeMs);
        while (!this.currentPoints.isEmpty() && this.currentPoints.peekFirst().getEventTime().before(cutoffTime)) {
            this.currentPoints.removeFirst();
        }
    }

    private static class DataPoint {
        private final Date eventTime;
        private final long value;

        public DataPoint(Date eventTime, long value) {
            this.eventTime = eventTime;
            this.value = value;
        }

        public Date getEventTime() {
            return this.eventTime;
        }

        public long getValue() {
            return this.value;
        }
    }
}

