/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.crypto.random;

import java.security.SecureRandom;
import java.util.Random;
import org.apache.flink.fs.azure.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.NativeCodeLoader;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.PerformanceAdvisory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class OpensslSecureRandom
extends Random {
    private static final long serialVersionUID = -7828193502768789584L;
    private static final Logger LOG = LoggerFactory.getLogger((String)OpensslSecureRandom.class.getName());
    private SecureRandom fallback = null;
    private static boolean nativeEnabled = false;

    public static boolean isNativeCodeLoaded() {
        return nativeEnabled;
    }

    public OpensslSecureRandom() {
        if (!nativeEnabled) {
            PerformanceAdvisory.LOG.debug("Build does not support openssl, falling back to Java SecureRandom.");
            this.fallback = new SecureRandom();
        }
    }

    @Override
    public void nextBytes(byte[] bytes) {
        if (!nativeEnabled || !this.nextRandBytes(bytes)) {
            this.fallback.nextBytes(bytes);
        }
    }

    @Override
    public void setSeed(long seed) {
    }

    @Override
    protected final int next(int numBits) {
        Preconditions.checkArgument(numBits >= 0 && numBits <= 32);
        int numBytes = (numBits + 7) / 8;
        byte[] b = new byte[numBytes];
        int next = 0;
        this.nextBytes(b);
        for (int i = 0; i < numBytes; ++i) {
            next = (next << 8) + (b[i] & 0xFF);
        }
        return next >>> numBytes * 8 - numBits;
    }

    private static native void initSR();

    private native boolean nextRandBytes(byte[] var1);

    static {
        if (NativeCodeLoader.isNativeCodeLoaded() && NativeCodeLoader.buildSupportsOpenssl()) {
            try {
                OpensslSecureRandom.initSR();
                nativeEnabled = true;
            }
            catch (Throwable t) {
                LOG.error("Failed to load Openssl SecureRandom", t);
            }
        }
    }
}

