/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.glue.schema.registry;

import com.amazonaws.services.schemaregistry.common.configs.GlueSchemaRegistryConfiguration;
import com.amazonaws.services.schemaregistry.serializers.GlueSchemaRegistrySerializationFacade;
import com.amazonaws.services.schemaregistry.utils.GlueSchemaRegistryUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.aws.util.AWSGeneralUtil;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.services.glue.model.DataFormat;

@PublicEvolving
public class GlueSchemaRegistryOutputStreamSerializer {
    private final String transportName;
    private final Map<String, Object> configs;
    private final GlueSchemaRegistrySerializationFacade glueSchemaRegistrySerializationFacade;

    public GlueSchemaRegistryOutputStreamSerializer(String transportName, Map<String, Object> configs) {
        this(transportName, configs, null);
    }

    public GlueSchemaRegistryOutputStreamSerializer(String transportName, Map<String, Object> configs, GlueSchemaRegistrySerializationFacade glueSchemaRegistrySerializationFacade) {
        this.transportName = transportName;
        this.configs = configs;
        AwsCredentialsProvider credentialsProvider = AWSGeneralUtil.getCredentialsProvider(configs);
        this.glueSchemaRegistrySerializationFacade = glueSchemaRegistrySerializationFacade != null ? glueSchemaRegistrySerializationFacade : GlueSchemaRegistrySerializationFacade.builder().credentialProvider(credentialsProvider).glueSchemaRegistryConfiguration(new GlueSchemaRegistryConfiguration(configs)).build();
    }

    public void registerSchemaAndSerializeStream(Schema schema, OutputStream out, byte[] data) throws IOException {
        byte[] bytes = this.glueSchemaRegistrySerializationFacade.encode(this.transportName, new com.amazonaws.services.schemaregistry.common.Schema(schema.toString(), DataFormat.AVRO.name(), this.getSchemaName()), data);
        out.write(bytes);
    }

    private String getSchemaName() {
        String schemaName = GlueSchemaRegistryUtils.getInstance().getSchemaName(this.configs);
        return schemaName != null ? schemaName : GlueSchemaRegistryUtils.getInstance().configureSchemaNamingStrategy(this.configs).getSchemaName(this.transportName);
    }
}

