/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.glue.schema.registry;

import com.amazonaws.services.schemaregistry.deserializers.GlueSchemaRegistryDeserializationFacade;
import com.amazonaws.services.schemaregistry.exception.AWSSchemaRegistryException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.aws.util.AWSGeneralUtil;
import org.apache.flink.formats.avro.utils.MutableByteArrayInputStream;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

@PublicEvolving
public class GlueSchemaRegistryInputStreamDeserializer {
    private final GlueSchemaRegistryDeserializationFacade glueSchemaRegistryDeserializationFacade;

    public GlueSchemaRegistryInputStreamDeserializer(Map<String, Object> configs) {
        AwsCredentialsProvider credentialsProvider = AWSGeneralUtil.getCredentialsProvider(configs);
        this.glueSchemaRegistryDeserializationFacade = GlueSchemaRegistryDeserializationFacade.builder().credentialProvider(credentialsProvider).configs(configs).build();
    }

    public GlueSchemaRegistryInputStreamDeserializer(GlueSchemaRegistryDeserializationFacade glueSchemaRegistryDeserializationFacade) {
        this.glueSchemaRegistryDeserializationFacade = glueSchemaRegistryDeserializationFacade;
    }

    public Schema getSchemaAndDeserializedStream(InputStream in) throws IOException {
        Schema schema;
        byte[] inputBytes = new byte[in.available()];
        in.read(inputBytes);
        in.reset();
        MutableByteArrayInputStream mutableByteArrayInputStream = (MutableByteArrayInputStream)in;
        String schemaDefinition = this.glueSchemaRegistryDeserializationFacade.getSchemaDefinition(inputBytes);
        byte[] deserializedBytes = this.glueSchemaRegistryDeserializationFacade.getActualData(inputBytes);
        mutableByteArrayInputStream.setBuffer(deserializedBytes);
        try {
            Schema.Parser schemaParser = new Schema.Parser();
            schema = schemaParser.parse(schemaDefinition);
        }
        catch (SchemaParseException e) {
            String message = "Error occurred while parsing schema, see inner exception for details.";
            throw new AWSSchemaRegistryException(message, (Throwable)e);
        }
        return schema;
    }
}

