/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.glue.schema.registry;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.formats.avro.SchemaCoder;
import org.apache.flink.formats.avro.glue.schema.registry.GlueSchemaRegistryInputStreamDeserializer;
import org.apache.flink.formats.avro.glue.schema.registry.GlueSchemaRegistryOutputStreamSerializer;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class GlueSchemaRegistryAvroSchemaCoder
implements SchemaCoder {
    private GlueSchemaRegistryInputStreamDeserializer glueSchemaRegistryInputStreamDeserializer;
    private GlueSchemaRegistryOutputStreamSerializer glueSchemaRegistryOutputStreamSerializer;

    public GlueSchemaRegistryAvroSchemaCoder(String transportName, Map<String, Object> configs) {
        this.glueSchemaRegistryInputStreamDeserializer = new GlueSchemaRegistryInputStreamDeserializer(configs);
        this.glueSchemaRegistryOutputStreamSerializer = new GlueSchemaRegistryOutputStreamSerializer(transportName, configs);
    }

    @VisibleForTesting
    protected GlueSchemaRegistryAvroSchemaCoder(GlueSchemaRegistryInputStreamDeserializer glueSchemaRegistryInputStreamDeserializer) {
        this.glueSchemaRegistryInputStreamDeserializer = glueSchemaRegistryInputStreamDeserializer;
    }

    @VisibleForTesting
    protected GlueSchemaRegistryAvroSchemaCoder(GlueSchemaRegistryOutputStreamSerializer glueSchemaRegistryOutputStreamSerializer) {
        this.glueSchemaRegistryOutputStreamSerializer = glueSchemaRegistryOutputStreamSerializer;
    }

    public Schema readSchema(InputStream in) throws IOException {
        return this.glueSchemaRegistryInputStreamDeserializer.getSchemaAndDeserializedStream(in);
    }

    public void writeSchema(Schema schema, OutputStream out) throws IOException {
        Preconditions.checkArgument((boolean)(out instanceof ByteArrayOutputStream), (Object)"The stream is not supported.");
        byte[] data = ((ByteArrayOutputStream)out).toByteArray();
        ((ByteArrayOutputStream)out).reset();
        this.glueSchemaRegistryOutputStreamSerializer.registerSchemaAndSerializeStream(schema, out, data);
    }
}

