/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.autoscaler.utils;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.autoscaler.ScalingSummary;
import org.apache.flink.autoscaler.metrics.EvaluatedScalingMetric;
import org.apache.flink.autoscaler.metrics.ScalingMetric;
import org.apache.flink.runtime.jobgraph.JobVertexID;

public class ResourceCheckUtils {
    public static int estimateNumTaskSlotsAfterRescale(Map<JobVertexID, Map<ScalingMetric, EvaluatedScalingMetric>> vertexMetrics, Map<JobVertexID, ScalingSummary> scalingSummaries, int numTaskSlotsUsed) {
        Map<JobVertexID, Integer> newParallelisms = ResourceCheckUtils.computeNewParallelisms(scalingSummaries, vertexMetrics);
        if (ResourceCheckUtils.currentMaxParallelism(vertexMetrics) == numTaskSlotsUsed) {
            return newParallelisms.values().stream().reduce(0, Integer::max);
        }
        return newParallelisms.values().stream().reduce(0, Integer::sum);
    }

    public static Map<JobVertexID, Integer> computeNewParallelisms(Map<JobVertexID, ScalingSummary> scalingSummaries, Map<JobVertexID, Map<ScalingMetric, EvaluatedScalingMetric>> vertexMetrics) {
        HashMap<JobVertexID, Integer> newParallelisms = new HashMap<JobVertexID, Integer>();
        for (Map.Entry<JobVertexID, Map<ScalingMetric, EvaluatedScalingMetric>> entry : vertexMetrics.entrySet()) {
            JobVertexID jobVertexID = entry.getKey();
            ScalingSummary scalingSummary = scalingSummaries.get(jobVertexID);
            if (scalingSummary != null) {
                newParallelisms.put(jobVertexID, scalingSummary.getNewParallelism());
                continue;
            }
            newParallelisms.put(jobVertexID, (int)entry.getValue().get((Object)ScalingMetric.PARALLELISM).getCurrent());
        }
        return newParallelisms;
    }

    private static int currentMaxParallelism(Map<JobVertexID, Map<ScalingMetric, EvaluatedScalingMetric>> vertexMetrics) {
        return vertexMetrics.values().stream().map(map -> (int)((EvaluatedScalingMetric)map.get((Object)ScalingMetric.PARALLELISM)).getCurrent()).reduce(0, Integer::max);
    }
}

