/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.autoscaler.utils;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.client.JobStatusMessage;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.messages.webmonitor.JobDetails;
import org.apache.flink.runtime.messages.webmonitor.MultipleJobsDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobStatusUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JobStatusUtils.class);

    public static List<JobStatusMessage> toJobStatusMessage(MultipleJobsDetails multipleJobsDetails) {
        return multipleJobsDetails.getJobs().stream().map(JobStatusUtils::toJobStatusMessage).collect(Collectors.toList());
    }

    public static JobStatusMessage toJobStatusMessage(JobDetails details) {
        return new JobStatusMessage(details.getJobId(), details.getJobName(), JobStatusUtils.getEffectiveStatus(details), details.getStartTime());
    }

    @VisibleForTesting
    static JobStatus getEffectiveStatus(JobDetails details) {
        int numRunning = details.getTasksPerState()[ExecutionState.RUNNING.ordinal()];
        int numFinished = details.getTasksPerState()[ExecutionState.FINISHED.ordinal()];
        boolean allRunningOrFinished = details.getNumTasks() == numRunning + numFinished;
        JobStatus effectiveStatus = details.getStatus();
        if (JobStatus.RUNNING.equals((Object)effectiveStatus) && !allRunningOrFinished) {
            LOG.debug("Adjusting job state from {} to {}", (Object)JobStatus.RUNNING, (Object)JobStatus.CREATED);
            return JobStatus.CREATED;
        }
        return effectiveStatus;
    }
}

