/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.autoscaler.utils;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class DateTimeUtils {
    private static final DateTimeFormatter DEFAULT_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public static String readable(Instant instant) {
        return DateTimeUtils.readable(instant, ZoneId.systemDefault());
    }

    public static String readable(Instant instant, ZoneId zoneId) {
        ZonedDateTime dateTime = instant.atZone(zoneId);
        return dateTime.format(DEFAULT_FORMATTER);
    }

    public static String kubernetes(Instant instant) {
        ZonedDateTime dateTime = instant.atZone(ZoneId.systemDefault());
        return dateTime.format(DateTimeFormatter.ISO_INSTANT);
    }

    public static Instant parseKubernetes(String datetime) {
        return Instant.parse(datetime);
    }
}

