/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.autoscaler.utils;

import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.flink.autoscaler.config.AutoScalerOptions;
import org.apache.flink.configuration.Configuration;
import org.quartz.impl.calendar.CronCalendar;
import org.quartz.impl.calendar.DailyCalendar;

public class CalendarUtils {
    static boolean isTimeIncluded(CronCalendar cron, long timeInMillis) {
        if (cron.getBaseCalendar() != null && !cron.getBaseCalendar().isTimeIncluded(timeInMillis)) {
            return false;
        }
        return cron.getCronExpression().isSatisfiedBy(new Date(timeInMillis));
    }

    static Optional<DailyCalendar> interpretAsDaily(String subExpression) {
        String[] splits = subExpression.split("-");
        if (splits.length != 2) {
            return Optional.empty();
        }
        try {
            DailyCalendar daily = new DailyCalendar(splits[0], splits[1]);
            daily.setInvertTimeRange(true);
            return Optional.of(daily);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    static Optional<CronCalendar> interpretAsCron(String subExpression) {
        try {
            return Optional.of(new CronCalendar(subExpression));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    static Optional<String> validateExcludedExpression(String expression) {
        String[] subExpressions = expression.split("&&");
        Optional<Object> dailyCalendar = Optional.empty();
        Optional<Object> cronCalendar = Optional.empty();
        if (subExpressions.length > 2) {
            return Optional.of(String.format("Invalid value %s in the autoscaler config %s", expression, AutoScalerOptions.EXCLUDED_PERIODS.key()));
        }
        for (String subExpression : subExpressions) {
            Optional<DailyCalendar> daily = CalendarUtils.interpretAsDaily(subExpression = subExpression.strip());
            dailyCalendar = daily.isPresent() ? daily : dailyCalendar;
            Optional<CronCalendar> cron = CalendarUtils.interpretAsCron(subExpression);
            Optional<Object> optional = cronCalendar = cron.isPresent() ? cron : cronCalendar;
            if (!daily.isEmpty() || !cron.isEmpty()) continue;
            return Optional.of(String.format("Invalid value %s in the autoscaler config %s, the value is neither a valid daily expression nor a valid cron expression", expression, AutoScalerOptions.EXCLUDED_PERIODS.key()));
        }
        if (subExpressions.length == 2 && (dailyCalendar.isEmpty() || cronCalendar.isEmpty())) {
            return Optional.of(String.format("Invalid value %s in the autoscaler config %s, the value can not be configured as dailyExpression && dailyExpression or cronExpression && cronExpression", expression, AutoScalerOptions.EXCLUDED_PERIODS.key()));
        }
        return Optional.empty();
    }

    static boolean inExcludedPeriod(String expression, Instant instant) {
        String[] subExpressions = expression.split("&&");
        boolean result = true;
        for (String subExpression : subExpressions) {
            Optional<DailyCalendar> daily = CalendarUtils.interpretAsDaily(subExpression = subExpression.strip());
            if (daily.isPresent()) {
                result = result && daily.get().isTimeIncluded(instant.toEpochMilli());
                continue;
            }
            Optional<CronCalendar> cron = CalendarUtils.interpretAsCron(subExpression);
            result = result && CalendarUtils.isTimeIncluded(cron.get(), instant.toEpochMilli());
        }
        return result;
    }

    public static boolean inExcludedPeriods(Configuration conf, Instant instant) {
        List excludedExpressions = (List)conf.get(AutoScalerOptions.EXCLUDED_PERIODS);
        for (String expression : excludedExpressions) {
            if (!CalendarUtils.inExcludedPeriod(expression, instant)) continue;
            return true;
        }
        return false;
    }

    public static Optional<String> validateExcludedPeriods(Configuration conf) {
        List excludedExpressions = (List)conf.get(AutoScalerOptions.EXCLUDED_PERIODS);
        for (String expression : excludedExpressions) {
            Optional<String> errorMsg = CalendarUtils.validateExcludedExpression(expression);
            if (!errorMsg.isPresent()) continue;
            return errorMsg;
        }
        return Optional.empty();
    }
}

