/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.autoscaler.utils;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.flink.autoscaler.config.AutoScalerOptions;
import org.apache.flink.autoscaler.metrics.EvaluatedScalingMetric;
import org.apache.flink.autoscaler.metrics.ScalingMetric;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobgraph.JobVertexID;

public class AutoScalerUtils {
    public static double getTargetProcessingCapacity(Map<ScalingMetric, EvaluatedScalingMetric> evaluatedMetrics, Configuration conf, double targetUtilization, boolean withRestart, Duration restartTime) {
        double lagCatchupTargetRate = evaluatedMetrics.get((Object)ScalingMetric.CATCH_UP_DATA_RATE).getCurrent();
        if (Double.isNaN(lagCatchupTargetRate)) {
            return Double.NaN;
        }
        double catchUpTargetSec = ((Duration)conf.get(AutoScalerOptions.CATCH_UP_DURATION)).toSeconds();
        targetUtilization = Math.max(0.0, targetUtilization);
        targetUtilization = Math.min(1.0, targetUtilization);
        double avgInputTargetRate = evaluatedMetrics.get((Object)ScalingMetric.TARGET_DATA_RATE).getAverage();
        if (Double.isNaN(avgInputTargetRate)) {
            return Double.NaN;
        }
        if (targetUtilization == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        double restartCatchupRate = !withRestart || catchUpTargetSec == 0.0 ? 0.0 : avgInputTargetRate * (double)restartTime.toSeconds() / catchUpTargetSec;
        double inputTargetAtUtilization = avgInputTargetRate / targetUtilization;
        return Math.round(lagCatchupTargetRate + restartCatchupRate + inputTargetAtUtilization);
    }

    public static boolean excludeVertexFromScaling(Configuration conf, JobVertexID jobVertexId) {
        return AutoScalerUtils.excludeVerticesFromScaling(conf, List.of(jobVertexId));
    }

    public static boolean excludeVerticesFromScaling(Configuration conf, Collection<JobVertexID> ids) {
        HashSet<String> excludedIds = new HashSet<String>((Collection)conf.get(AutoScalerOptions.VERTEX_EXCLUDE_IDS));
        boolean anyAdded = false;
        for (JobVertexID id : ids) {
            String hexString = id.toHexString();
            anyAdded |= excludedIds.add(hexString);
        }
        conf.set(AutoScalerOptions.VERTEX_EXCLUDE_IDS, new ArrayList(excludedIds));
        return anyAdded;
    }
}

