/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.autoscaler.utils;

import java.io.IOException;
import org.apache.flink.autoscaler.metrics.Edge;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.KeyDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.module.SimpleModule;

public class AutoScalerSerDeModule
extends SimpleModule {
    public AutoScalerSerDeModule() {
        this.addKeySerializer(JobVertexID.class, new JobVertexIdKeySerializer());
        this.addKeyDeserializer(JobVertexID.class, new JobVertexIdKeyDeserializer());
        this.addKeySerializer(Edge.class, new EdgeKeySerializer());
        this.addKeyDeserializer(Edge.class, new EdgeKeyDeserializer());
    }

    private static class EdgeKeyDeserializer
    extends KeyDeserializer {
        private EdgeKeyDeserializer() {
        }

        public Object deserializeKey(String s, DeserializationContext deserializationContext) {
            String[] arr = s.split(",");
            return new Edge(JobVertexID.fromHexString((String)arr[0]), JobVertexID.fromHexString((String)arr[1]));
        }
    }

    private static class EdgeKeySerializer
    extends JsonSerializer<Edge> {
        private EdgeKeySerializer() {
        }

        public void serialize(Edge value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeFieldName(value.getFrom().toHexString() + "," + value.getTo().toHexString());
        }
    }

    private static class JobVertexIdKeyDeserializer
    extends KeyDeserializer {
        private JobVertexIdKeyDeserializer() {
        }

        public Object deserializeKey(String s, DeserializationContext deserializationContext) {
            return JobVertexID.fromHexString((String)s);
        }
    }

    private static class JobVertexIdKeySerializer
    extends JsonSerializer<JobVertexID> {
        private JobVertexIdKeySerializer() {
        }

        public void serialize(JobVertexID value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeFieldName(value.toHexString());
        }
    }
}

