/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.autoscaler.tuning;

import java.util.Map;
import org.apache.flink.autoscaler.JobAutoScalerContext;
import org.apache.flink.autoscaler.ScalingSummary;
import org.apache.flink.autoscaler.config.AutoScalerOptions;
import org.apache.flink.autoscaler.metrics.EvaluatedMetrics;
import org.apache.flink.autoscaler.metrics.ScalingMetric;
import org.apache.flink.autoscaler.tuning.MemoryBudget;
import org.apache.flink.autoscaler.utils.ResourceCheckUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryScaling {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryScaling.class);

    public static MemorySize applyMemoryScaling(MemorySize currentMemorySize, MemoryBudget memoryBudget, JobAutoScalerContext<?> context, Map<JobVertexID, ScalingSummary> scalingSummaries, EvaluatedMetrics evaluatedMetrics) {
        if (!((Boolean)context.getConfiguration().get(AutoScalerOptions.MEMORY_SCALING_ENABLED)).booleanValue()) {
            return currentMemorySize;
        }
        double memScalingFactor = MemoryScaling.getMemoryScalingFactor(evaluatedMetrics, scalingSummaries, context.getConfiguration());
        long additionalBytes = memoryBudget.budget((long)(memScalingFactor * (double)currentMemorySize.getBytes()) - currentMemorySize.getBytes());
        MemorySize scaledTotalMemory = new MemorySize(currentMemorySize.getBytes() + additionalBytes);
        LOG.info("Scaling factor: {}, Adjusting memory from {} to {}.", new Object[]{memScalingFactor, currentMemorySize, scaledTotalMemory});
        return scaledTotalMemory;
    }

    private static double getMemoryScalingFactor(EvaluatedMetrics evaluatedMetrics, Map<JobVertexID, ScalingSummary> scalingSummaries, Configuration config) {
        int numTaskSlotsUsed = (int)evaluatedMetrics.getGlobalMetrics().get((Object)ScalingMetric.NUM_TASK_SLOTS_USED).getCurrent();
        int numTaskSlotsAfterRescale = ResourceCheckUtils.estimateNumTaskSlotsAfterRescale(evaluatedMetrics.getVertexMetrics(), scalingSummaries, numTaskSlotsUsed);
        int numTaskSlotsPerTM = (Integer)config.get(TaskManagerOptions.NUM_TASK_SLOTS);
        int numTMsBeforeRescale = (int)Math.ceil((double)numTaskSlotsUsed / (double)numTaskSlotsPerTM);
        int numTMsAfterRescale = (int)Math.ceil((double)numTaskSlotsAfterRescale / (double)numTaskSlotsPerTM);
        return Math.max(1.0, (double)numTMsBeforeRescale / (double)numTMsAfterRescale);
    }
}

