/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.autoscaler.tuning;

import org.apache.flink.util.Preconditions;

public class MemoryBudget {
    private long remaining;

    public MemoryBudget(long remaining) {
        Preconditions.checkArgument((remaining >= 0L ? 1 : 0) != 0);
        this.remaining = remaining;
    }

    public long budget(long amount) {
        Preconditions.checkArgument((amount >= 0L ? 1 : 0) != 0);
        long budgeted = Math.min(amount, this.remaining);
        this.remaining -= budgeted;
        return budgeted;
    }

    public long getRemaining() {
        return this.remaining;
    }
}

