/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.autoscaler.tuning;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.FallbackKey;

public class ConfigChanges {
    private final Map<String, String> overrides = new HashMap<String, String>();
    private final Set<String> removals = new HashSet<String>();

    public <T> ConfigChanges addOverride(ConfigOption<T> configOption, T value) {
        this.overrides.put(configOption.key(), (String)ConfigurationUtils.convertValue(value, String.class));
        return this;
    }

    public ConfigChanges addOverride(String key, String value) {
        this.overrides.put(key, value);
        return this;
    }

    public ConfigChanges addRemoval(ConfigOption<?> configOption) {
        this.removals.add(configOption.key());
        for (FallbackKey fallbackKey : configOption.fallbackKeys()) {
            this.removals.add(fallbackKey.getKey());
        }
        return this;
    }

    public Configuration newConfigWithOverrides(Configuration existingConfig) {
        Configuration config = new Configuration(existingConfig);
        for (String key : this.removals) {
            config.removeKey(key);
        }
        config.addAll(Configuration.fromMap(this.overrides));
        return config;
    }

    public Map<String, String> getOverrides() {
        return this.overrides;
    }

    public Set<String> getRemovals() {
        return this.removals;
    }
}

