/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.autoscaler.topology;

import java.util.Map;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.autoscaler.topology.IOMetrics;
import org.apache.flink.autoscaler.topology.ShipStrategy;
import org.apache.flink.runtime.instance.SlotSharingGroupId;
import org.apache.flink.runtime.jobgraph.JobVertexID;

public class VertexInfo {
    private final JobVertexID id;
    private final Map<JobVertexID, ShipStrategy> inputs;
    private final SlotSharingGroupId slotSharingGroupId;
    private Map<JobVertexID, ShipStrategy> outputs;
    private final int parallelism;
    private int maxParallelism;
    private int numSourcePartitions;
    private final boolean finished;
    private IOMetrics ioMetrics;

    public VertexInfo(JobVertexID id, SlotSharingGroupId slotSharingGroupId, Map<JobVertexID, ShipStrategy> inputs, int parallelism, int maxParallelism, boolean finished, IOMetrics ioMetrics) {
        this.id = id;
        this.slotSharingGroupId = slotSharingGroupId;
        this.inputs = inputs;
        this.parallelism = parallelism;
        this.maxParallelism = maxParallelism;
        this.finished = finished;
        this.ioMetrics = ioMetrics;
    }

    @VisibleForTesting
    public VertexInfo(JobVertexID id, Map<JobVertexID, ShipStrategy> inputs, int parallelism, int maxParallelism, IOMetrics ioMetrics) {
        this(id, null, inputs, parallelism, maxParallelism, false, ioMetrics);
    }

    @VisibleForTesting
    public VertexInfo(JobVertexID id, Map<JobVertexID, ShipStrategy> inputs, int parallelism, int maxParallelism, boolean finished, IOMetrics ioMetrics) {
        this(id, null, inputs, parallelism, maxParallelism, finished, ioMetrics);
    }

    @VisibleForTesting
    public VertexInfo(JobVertexID id, Map<JobVertexID, ShipStrategy> inputs, int parallelism, int maxParallelism) {
        this(id, inputs, parallelism, maxParallelism, null);
    }

    public JobVertexID getId() {
        return this.id;
    }

    public Map<JobVertexID, ShipStrategy> getInputs() {
        return this.inputs;
    }

    public SlotSharingGroupId getSlotSharingGroupId() {
        return this.slotSharingGroupId;
    }

    public Map<JobVertexID, ShipStrategy> getOutputs() {
        return this.outputs;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public int getMaxParallelism() {
        return this.maxParallelism;
    }

    public int getNumSourcePartitions() {
        return this.numSourcePartitions;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public IOMetrics getIoMetrics() {
        return this.ioMetrics;
    }

    public void setOutputs(Map<JobVertexID, ShipStrategy> outputs) {
        this.outputs = outputs;
    }

    public void setIoMetrics(IOMetrics ioMetrics) {
        this.ioMetrics = ioMetrics;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VertexInfo)) {
            return false;
        }
        VertexInfo other = (VertexInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getParallelism() != other.getParallelism()) {
            return false;
        }
        if (this.getMaxParallelism() != other.getMaxParallelism()) {
            return false;
        }
        if (this.getNumSourcePartitions() != other.getNumSourcePartitions()) {
            return false;
        }
        if (this.isFinished() != other.isFinished()) {
            return false;
        }
        JobVertexID this$id = this.getId();
        JobVertexID other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<JobVertexID, ShipStrategy> this$inputs = this.getInputs();
        Map<JobVertexID, ShipStrategy> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
            return false;
        }
        SlotSharingGroupId this$slotSharingGroupId = this.getSlotSharingGroupId();
        SlotSharingGroupId other$slotSharingGroupId = other.getSlotSharingGroupId();
        if (this$slotSharingGroupId == null ? other$slotSharingGroupId != null : !this$slotSharingGroupId.equals(other$slotSharingGroupId)) {
            return false;
        }
        Map<JobVertexID, ShipStrategy> this$outputs = this.getOutputs();
        Map<JobVertexID, ShipStrategy> other$outputs = other.getOutputs();
        if (this$outputs == null ? other$outputs != null : !((Object)this$outputs).equals(other$outputs)) {
            return false;
        }
        IOMetrics this$ioMetrics = this.getIoMetrics();
        IOMetrics other$ioMetrics = other.getIoMetrics();
        return !(this$ioMetrics == null ? other$ioMetrics != null : !((Object)this$ioMetrics).equals(other$ioMetrics));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VertexInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getParallelism();
        result = result * 59 + this.getMaxParallelism();
        result = result * 59 + this.getNumSourcePartitions();
        result = result * 59 + (this.isFinished() ? 79 : 97);
        JobVertexID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<JobVertexID, ShipStrategy> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        SlotSharingGroupId $slotSharingGroupId = this.getSlotSharingGroupId();
        result = result * 59 + ($slotSharingGroupId == null ? 43 : $slotSharingGroupId.hashCode());
        Map<JobVertexID, ShipStrategy> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : ((Object)$outputs).hashCode());
        IOMetrics $ioMetrics = this.getIoMetrics();
        result = result * 59 + ($ioMetrics == null ? 43 : ((Object)$ioMetrics).hashCode());
        return result;
    }

    public String toString() {
        return "VertexInfo(id=" + this.getId() + ", inputs=" + this.getInputs() + ", slotSharingGroupId=" + this.getSlotSharingGroupId() + ", outputs=" + this.getOutputs() + ", parallelism=" + this.getParallelism() + ", maxParallelism=" + this.getMaxParallelism() + ", numSourcePartitions=" + this.getNumSourcePartitions() + ", finished=" + this.isFinished() + ", ioMetrics=" + this.getIoMetrics() + ")";
    }

    public void setNumSourcePartitions(int numSourcePartitions) {
        this.numSourcePartitions = numSourcePartitions;
    }
}

