/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.autoscaler.topology;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.autoscaler.exceptions.NotReadyException;
import org.apache.flink.autoscaler.topology.IOMetrics;
import org.apache.flink.autoscaler.topology.ShipStrategy;
import org.apache.flink.autoscaler.topology.VertexInfo;
import org.apache.flink.runtime.instance.SlotSharingGroupId;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.shaded.guava31.com.google.common.collect.ImmutableMap;
import org.apache.flink.shaded.guava31.com.google.common.collect.ImmutableSet;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;

public class JobTopology {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final Map<JobVertexID, VertexInfo> vertexInfos;
    private final Map<SlotSharingGroupId, Set<JobVertexID>> slotSharingGroupMapping;
    private final Set<JobVertexID> finishedVertices;
    private final List<JobVertexID> verticesInTopologicalOrder;

    public JobTopology(Collection<VertexInfo> vertexInfo) {
        this((Set<VertexInfo>)new HashSet<VertexInfo>(vertexInfo));
    }

    public JobTopology(VertexInfo ... vertexInfo) {
        this(Set.of(vertexInfo));
    }

    public JobTopology(Set<VertexInfo> vertexInfo) {
        HashMap<JobVertexID, Map> vertexOutputs = new HashMap<JobVertexID, Map>();
        this.vertexInfos = ImmutableMap.copyOf(vertexInfo.stream().collect(Collectors.toMap(VertexInfo::getId, v -> v)));
        HashMap vertexSlotSharingGroupMapping = new HashMap();
        ImmutableSet.Builder finishedVertices = ImmutableSet.builder();
        vertexInfo.forEach(info -> {
            JobVertexID vertexId = info.getId();
            vertexOutputs.computeIfAbsent(vertexId, id -> new HashMap());
            info.getInputs().forEach((inputId, shipStrategy) -> vertexOutputs.computeIfAbsent((JobVertexID)inputId, id -> new HashMap()).put(vertexId, shipStrategy));
            SlotSharingGroupId slotSharingGroupId = info.getSlotSharingGroupId();
            if (slotSharingGroupId != null) {
                vertexSlotSharingGroupMapping.computeIfAbsent(slotSharingGroupId, id -> new HashSet()).add(vertexId);
            }
            if (info.isFinished()) {
                finishedVertices.add((Object)vertexId);
            }
        });
        vertexOutputs.forEach((v, outputs) -> this.vertexInfos.get(v).setOutputs((Map<JobVertexID, ShipStrategy>)outputs));
        this.slotSharingGroupMapping = ImmutableMap.copyOf(vertexSlotSharingGroupMapping);
        this.finishedVertices = finishedVertices.build();
        this.verticesInTopologicalOrder = this.returnVerticesInTopologicalOrder();
    }

    public VertexInfo get(JobVertexID jvi) {
        return this.vertexInfos.get(jvi);
    }

    public boolean isSource(JobVertexID jobVertexID) {
        return this.get(jobVertexID).getInputs().isEmpty();
    }

    private List<JobVertexID> returnVerticesInTopologicalOrder() {
        ArrayList<JobVertexID> sorted = new ArrayList<JobVertexID>(this.vertexInfos.size());
        HashMap<JobVertexID, List> remainingInputs = new HashMap<JobVertexID, List>(this.vertexInfos.size());
        this.vertexInfos.forEach((id, v) -> remainingInputs.put((JobVertexID)id, new ArrayList<JobVertexID>(v.getInputs().keySet())));
        while (!remainingInputs.isEmpty()) {
            ArrayList verticesWithZeroIndegree = new ArrayList();
            remainingInputs.forEach((v, inputs) -> {
                if (inputs.isEmpty()) {
                    verticesWithZeroIndegree.add(v);
                }
            });
            verticesWithZeroIndegree.forEach(v -> {
                remainingInputs.remove(v);
                this.vertexInfos.get(v).getOutputs().keySet().forEach(o -> ((List)remainingInputs.get(o)).remove(v));
            });
            sorted.addAll(verticesWithZeroIndegree);
        }
        return sorted;
    }

    public static JobTopology fromJsonPlan(String jsonPlan, Map<JobVertexID, SlotSharingGroupId> slotSharingGroupIdMap, Map<JobVertexID, Integer> maxParallelismMap, Map<JobVertexID, IOMetrics> metrics, Set<JobVertexID> finishedVertices) throws JsonProcessingException {
        ObjectNode plan = (ObjectNode)objectMapper.readValue(jsonPlan, ObjectNode.class);
        ArrayNode nodes = (ArrayNode)plan.get("nodes");
        if (nodes == null || nodes.isEmpty()) {
            throw new NotReadyException("No nodes found in the plan, job is not ready yet");
        }
        HashSet<VertexInfo> vertexInfo = new HashSet<VertexInfo>();
        for (JsonNode node : nodes) {
            JobVertexID vertexId = JobVertexID.fromHexString((String)node.get("id").asText());
            HashMap<JobVertexID, ShipStrategy> inputs = new HashMap<JobVertexID, ShipStrategy>();
            IOMetrics ioMetrics = metrics.get(vertexId);
            boolean finished = finishedVertices.contains(vertexId);
            vertexInfo.add(new VertexInfo(vertexId, slotSharingGroupIdMap.get(vertexId), inputs, node.get("parallelism").asInt(), maxParallelismMap.get(vertexId), finished, finished ? IOMetrics.FINISHED_METRICS : ioMetrics));
            if (!node.has("inputs")) continue;
            for (JsonNode input : node.get("inputs")) {
                inputs.put(JobVertexID.fromHexString((String)input.get("id").asText()), ShipStrategy.of(input.get("ship_strategy").asText()));
            }
        }
        return new JobTopology((Set<VertexInfo>)vertexInfo);
    }

    public String toString() {
        return "JobTopology(vertexInfos=" + this.getVertexInfos() + ", slotSharingGroupMapping=" + this.getSlotSharingGroupMapping() + ", finishedVertices=" + this.getFinishedVertices() + ", verticesInTopologicalOrder=" + this.getVerticesInTopologicalOrder() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobTopology)) {
            return false;
        }
        JobTopology other = (JobTopology)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<JobVertexID, VertexInfo> this$vertexInfos = this.getVertexInfos();
        Map<JobVertexID, VertexInfo> other$vertexInfos = other.getVertexInfos();
        if (this$vertexInfos == null ? other$vertexInfos != null : !((Object)this$vertexInfos).equals(other$vertexInfos)) {
            return false;
        }
        Map<SlotSharingGroupId, Set<JobVertexID>> this$slotSharingGroupMapping = this.getSlotSharingGroupMapping();
        Map<SlotSharingGroupId, Set<JobVertexID>> other$slotSharingGroupMapping = other.getSlotSharingGroupMapping();
        if (this$slotSharingGroupMapping == null ? other$slotSharingGroupMapping != null : !((Object)this$slotSharingGroupMapping).equals(other$slotSharingGroupMapping)) {
            return false;
        }
        Set<JobVertexID> this$finishedVertices = this.getFinishedVertices();
        Set<JobVertexID> other$finishedVertices = other.getFinishedVertices();
        if (this$finishedVertices == null ? other$finishedVertices != null : !((Object)this$finishedVertices).equals(other$finishedVertices)) {
            return false;
        }
        List<JobVertexID> this$verticesInTopologicalOrder = this.getVerticesInTopologicalOrder();
        List<JobVertexID> other$verticesInTopologicalOrder = other.getVerticesInTopologicalOrder();
        return !(this$verticesInTopologicalOrder == null ? other$verticesInTopologicalOrder != null : !((Object)this$verticesInTopologicalOrder).equals(other$verticesInTopologicalOrder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JobTopology;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<JobVertexID, VertexInfo> $vertexInfos = this.getVertexInfos();
        result = result * 59 + ($vertexInfos == null ? 43 : ((Object)$vertexInfos).hashCode());
        Map<SlotSharingGroupId, Set<JobVertexID>> $slotSharingGroupMapping = this.getSlotSharingGroupMapping();
        result = result * 59 + ($slotSharingGroupMapping == null ? 43 : ((Object)$slotSharingGroupMapping).hashCode());
        Set<JobVertexID> $finishedVertices = this.getFinishedVertices();
        result = result * 59 + ($finishedVertices == null ? 43 : ((Object)$finishedVertices).hashCode());
        List<JobVertexID> $verticesInTopologicalOrder = this.getVerticesInTopologicalOrder();
        result = result * 59 + ($verticesInTopologicalOrder == null ? 43 : ((Object)$verticesInTopologicalOrder).hashCode());
        return result;
    }

    public Map<JobVertexID, VertexInfo> getVertexInfos() {
        return this.vertexInfos;
    }

    public Map<SlotSharingGroupId, Set<JobVertexID>> getSlotSharingGroupMapping() {
        return this.slotSharingGroupMapping;
    }

    public Set<JobVertexID> getFinishedVertices() {
        return this.finishedVertices;
    }

    public List<JobVertexID> getVerticesInTopologicalOrder() {
        return this.verticesInTopologicalOrder;
    }
}

