/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.autoscaler.topology;

import org.apache.flink.runtime.rest.messages.job.metrics.IOMetricsInfo;

public final class IOMetrics {
    public static final IOMetrics FINISHED_METRICS = new IOMetrics(0L, 0L, 0.0);
    private final long numRecordsIn;
    private final long numRecordsOut;
    private final double accumulatedBusyTime;

    public static IOMetrics from(IOMetricsInfo metricsInfo) {
        return new IOMetrics(metricsInfo.getRecordsRead(), metricsInfo.getRecordsWritten(), metricsInfo.getAccumulatedBusy());
    }

    public IOMetrics(long numRecordsIn, long numRecordsOut, double accumulatedBusyTime) {
        this.numRecordsIn = numRecordsIn;
        this.numRecordsOut = numRecordsOut;
        this.accumulatedBusyTime = accumulatedBusyTime;
    }

    public long getNumRecordsIn() {
        return this.numRecordsIn;
    }

    public long getNumRecordsOut() {
        return this.numRecordsOut;
    }

    public double getAccumulatedBusyTime() {
        return this.accumulatedBusyTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IOMetrics)) {
            return false;
        }
        IOMetrics other = (IOMetrics)o;
        if (this.getNumRecordsIn() != other.getNumRecordsIn()) {
            return false;
        }
        if (this.getNumRecordsOut() != other.getNumRecordsOut()) {
            return false;
        }
        return Double.compare(this.getAccumulatedBusyTime(), other.getAccumulatedBusyTime()) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $numRecordsIn = this.getNumRecordsIn();
        result = result * 59 + (int)($numRecordsIn >>> 32 ^ $numRecordsIn);
        long $numRecordsOut = this.getNumRecordsOut();
        result = result * 59 + (int)($numRecordsOut >>> 32 ^ $numRecordsOut);
        long $accumulatedBusyTime = Double.doubleToLongBits(this.getAccumulatedBusyTime());
        result = result * 59 + (int)($accumulatedBusyTime >>> 32 ^ $accumulatedBusyTime);
        return result;
    }

    public String toString() {
        return "IOMetrics(numRecordsIn=" + this.getNumRecordsIn() + ", numRecordsOut=" + this.getNumRecordsOut() + ", accumulatedBusyTime=" + this.getAccumulatedBusyTime() + ")";
    }
}

